/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.headerenrichment.DismissDialogCallback;
import com.telenor.connect.headerenrichment.HeLogic;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.id.Claims;
import com.telenor.connect.ui.AuthenticationButton;
import com.telenor.connect.ui.ConnectCustomTabLoginButton;
import com.telenor.connect.ui.TurnOnMobileDataDialogFragment;
import com.telenor.connect.utils.TurnOnMobileDataDialogAnalytics;
import java.util.ArrayList;
import java.util.Map;

public class ConnectLoginButton
extends RelativeLayout
implements AuthenticationButton,
TurnOnMobileDataDialogFragment.ContinueListener {
    private ConnectCustomTabLoginButton loginButton;
    private ProgressBar progressBar;
    private View.OnClickListener loginClickListener;

    public ConnectLoginButton(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        ConnectLoginButton.inflate((Context)this.getContext(), (int)R.layout.com_telenor_connect_login_button_with_progress_bar, (ViewGroup)this);
        this.progressBar = (ProgressBar)this.findViewById(R.id.com_telenor_connect_login_button_progress_bar);
        this.loginButton = (ConnectCustomTabLoginButton)this.findViewById(R.id.com_telenor_connect_login_button);
        this.loginButton.setShowLoadingCallback(new ShowLoadingCallback(){

            @Override
            public void stop() {
                ConnectLoginButton.this.setLoading(false);
            }
        });
        this.loginClickListener = this.loginButton.getOnClickListener();
        this.loginButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean showTurnOnMobileDataDialog;
                ConnectLoginButton.this.setLoading(true);
                boolean bl = showTurnOnMobileDataDialog = !HeLogic.isCellularDataNetworkConnected() && ConnectSdk.isTurnOnMobileDataDialogEnabled();
                if (!showTurnOnMobileDataDialog || HeLogic.canNotDirectNetworkTraffic) {
                    ConnectLoginButton.this.loginClickListener.onClick(v);
                    return;
                }
                final TurnOnMobileDataDialogFragment turnOnMobileDataDialogFragment = new TurnOnMobileDataDialogFragment();
                ConnectLoginButton.this.loginButton.setDismissDialogCallback(new DismissDialogCallback(){

                    @Override
                    public void dismiss() {
                        turnOnMobileDataDialogFragment.dismiss();
                    }

                    @Override
                    @RequiresApi(api=21)
                    public TurnOnMobileDataDialogAnalytics getAnalytics() {
                        return new TurnOnMobileDataDialogAnalytics(ConnectSdk.isTurnOnMobileDataDialogEnabled(), true, turnOnMobileDataDialogFragment.isAtomaticButtonPressed(), turnOnMobileDataDialogFragment.isManualButtonPressed());
                    }
                });
                FragmentManager fragmentManager = ((FragmentActivity)ConnectLoginButton.this.loginButton.getActivity()).getSupportFragmentManager();
                turnOnMobileDataDialogFragment.show(fragmentManager, "TurnOnMobileDataFragment");
                turnOnMobileDataDialogFragment.setContinueListener(ConnectLoginButton.this);
            }
        });
    }

    private void setLoading(boolean loading) {
        this.progressBar.setVisibility(loading ? 0 : 4);
        this.loginButton.setEnabled(!loading);
    }

    @Override
    public void onContinueClicked(DialogFragment dialog) {
        this.loginClickListener.onClick(null);
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        this.setLoading(false);
    }

    public ConnectLoginButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConnectLoginButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public ConnectLoginButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Intent intent = this.loginButton.getActivity().getIntent();
        boolean ongoingAuth = intent != null && ConnectSdk.hasValidRedirectUrlCall(intent);
        this.setLoading(ongoingAuth);
    }

    @Override
    public ArrayList<String> getAcrValues() {
        return this.loginButton.getAcrValues();
    }

    @Override
    public Map<String, String> getLoginParameters() {
        return this.loginButton.getLoginParameters();
    }

    @Override
    public ArrayList<String> getLoginScopeTokens() {
        return this.loginButton.getLoginScopeTokens();
    }

    @Override
    public int getRequestCode() {
        return this.loginButton.getRequestCode();
    }

    @Override
    public Claims getClaims() {
        return this.loginButton.getClaims();
    }

    @Override
    public int getCustomLoadingLayout() {
        return this.loginButton.getCustomLoadingLayout();
    }

    @Override
    public View.OnClickListener getOnClickListener() {
        return this.loginButton.getOnClickListener();
    }

    @Override
    public void setAcrValues(String ... acrValues) {
        this.loginButton.setAcrValues(acrValues);
    }

    @Override
    public void setAcrValues(ArrayList<String> acrValues) {
        this.loginButton.setAcrValues(acrValues);
    }

    @Override
    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginButton.setLoginScopeTokens(scopeTokens);
    }

    @Override
    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginButton.setLoginScopeTokens(scopeTokens);
    }

    @Override
    public void setExtraLoginParameters(Map<String, String> parameters) {
        this.loginButton.setExtraLoginParameters(parameters);
    }

    @Override
    public void setRequestCode(int requestCode) {
        this.loginButton.setRequestCode(requestCode);
    }

    @Override
    public void setClaims(Claims claims) {
        this.loginButton.setClaims(claims);
    }

    @Override
    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.loginButton.setCustomLoadingLayout(customLoadingLayout);
    }
}

