/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.support.annotation.Nullable;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.utils.Validator;
import java.util.Calendar;
import java.util.Date;

public class ConnectTokens {
    private final String accessToken;
    private final Date expirationDate;
    private final IdToken idToken;
    private final String refreshToken;
    private final String scope;
    private final String tokenType;

    public ConnectTokens(ConnectTokensTO connectTokensTO, @Nullable Date serverTimestamp) {
        Validator.validateTokens(connectTokensTO, serverTimestamp);
        this.accessToken = connectTokensTO.getAccessToken();
        Calendar instance = Calendar.getInstance();
        instance.add(13, (int)connectTokensTO.getExpiresIn());
        this.expirationDate = instance.getTime();
        this.idToken = connectTokensTO.getIdToken();
        this.refreshToken = connectTokensTO.getRefreshToken();
        this.scope = connectTokensTO.getScope();
        this.tokenType = connectTokensTO.getTokenType();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public IdToken getIdToken() {
        return this.idToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean accessTokenHasExpired() {
        return Calendar.getInstance().getTime().after(this.expirationDate);
    }
}

