/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.telenor.connect.ConnectException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class IdToken {
    private static final String AUTHENTICATION_USERNAME = "td_au";
    private static final String NAME = "name";
    private static final String EMAIL = "email";
    private static final String EMAIL_VERIFIED = "email_verified";
    private static final String PHONE_NUMBER = "phone_number";
    private static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    private static final String NONCE = "nonce";
    private final String serializedSignedJwt;
    private final String subject;
    private final Date expirationDate;
    private final String authenticationUsername;
    private final String name;
    private final String email;
    private final Boolean emailVerified;
    private final String phoneNumber;
    private final Boolean phoneNumberVerified;
    private final String nonce;

    public IdToken(String serializedSignedJwt) {
        ReadOnlyJWTClaimsSet jwtClaimsSet;
        this.serializedSignedJwt = serializedSignedJwt;
        try {
            jwtClaimsSet = SignedJWT.parse((String)serializedSignedJwt).getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new ConnectException("Could not parse saved id token. idToken=" + this, e);
        }
        this.subject = jwtClaimsSet.getSubject();
        this.expirationDate = jwtClaimsSet.getExpirationTime();
        Map customClaims = jwtClaimsSet.getCustomClaims();
        this.authenticationUsername = customClaims.containsKey(AUTHENTICATION_USERNAME) ? (String)customClaims.get(AUTHENTICATION_USERNAME) : null;
        this.name = customClaims.containsKey(NAME) ? (String)customClaims.get(NAME) : null;
        this.email = customClaims.containsKey(EMAIL) ? (String)customClaims.get(EMAIL) : null;
        this.emailVerified = customClaims.containsKey(EMAIL_VERIFIED) ? (Boolean)customClaims.get(EMAIL_VERIFIED) : null;
        this.phoneNumber = customClaims.containsKey(PHONE_NUMBER) ? (String)customClaims.get(PHONE_NUMBER) : null;
        this.phoneNumberVerified = customClaims.containsKey(PHONE_NUMBER_VERIFIED) ? (Boolean)customClaims.get(PHONE_NUMBER_VERIFIED) : null;
        this.nonce = customClaims.containsKey(NONCE) ? (String)customClaims.get(NONCE) : null;
    }

    public String getSerializedSignedJwt() {
        return this.serializedSignedJwt;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Boolean getPhoneNumberVerified() {
        return this.phoneNumberVerified;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String toString() {
        return "IdToken{serializedSignedJwt='" + this.serializedSignedJwt + '\'' + ", subject='" + this.subject + '\'' + ", expirationDate=" + this.expirationDate + ", authenticationUsername='" + this.authenticationUsername + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", emailVerified=" + this.emailVerified + ", phoneNumber='" + this.phoneNumber + '\'' + ", phoneNumberVerified=" + this.phoneNumberVerified + ", nonce=" + this.nonce + '}';
    }
}

