/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.mobileconnect.operatordiscovery;

public final class OperatorDiscoveryConfig {
    private String operatorDiscoveryEndpoint;
    private String operatorDiscoveryClientId;
    private String operatorDiscoveryClientSecret;
    private String operatorDiscoveryRedirectUri;

    private OperatorDiscoveryConfig() {
    }

    public String getOperatorDiscoveryEndpoint() {
        return this.operatorDiscoveryEndpoint;
    }

    public String getOperatorDiscoveryClientId() {
        return this.operatorDiscoveryClientId;
    }

    public String getOperatorDiscoveryClientSecret() {
        return this.operatorDiscoveryClientSecret;
    }

    public String getOperatorDiscoveryRedirectUri() {
        return this.operatorDiscoveryRedirectUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OperatorDiscoveryConfig operatorDiscoveryConfig = new OperatorDiscoveryConfig();
        private int flags = 0;

        public Builder endpoint(String operatorDiscoveryEndpoint) {
            this.operatorDiscoveryConfig.operatorDiscoveryEndpoint = operatorDiscoveryEndpoint;
            this.flags |= 1;
            return this;
        }

        public Builder clientId(String operatorDiscoveryClientId) {
            this.operatorDiscoveryConfig.operatorDiscoveryClientId = operatorDiscoveryClientId;
            this.flags |= 2;
            return this;
        }

        public Builder clientSecret(String operatorDiscoveryClientSecret) {
            this.operatorDiscoveryConfig.operatorDiscoveryClientSecret = operatorDiscoveryClientSecret;
            this.flags |= 4;
            return this;
        }

        public Builder redirectUri(String operatorDiscoveryRedirectUri) {
            this.operatorDiscoveryConfig.operatorDiscoveryRedirectUri = operatorDiscoveryRedirectUri;
            this.flags |= 8;
            return this;
        }

        public OperatorDiscoveryConfig build() {
            if (this.flags != 15) {
                throw new RuntimeException("Incomplete operator discover config");
            }
            return this.operatorDiscoveryConfig;
        }
    }
}

