/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.ui.ConnectWebViewLoginButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import com.telenor.connect.utils.CustomTabsHelper;
import com.telenor.connect.utils.Validator;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class ConnectLoginButton
extends ConnectWebViewLoginButton {
    private static final Uri PRE_FETCH_URL = Uri.parse((String)ConnectSdk.getConnectApiUrl().newBuilder().addPathSegment("id").addPathSegment("android-sdk-prefetch-static-resources").build().uri().toString());
    private View.OnClickListener onClickListener;
    private CustomTabsServiceConnection connection;
    private boolean customTabsSupported = false;
    private boolean launchCustomTabInNewTask = true;
    private BrowserType browserType;
    private ConnectStore connectStore = new ConnectStore(this.getContext());
    private CustomTabsSession session;

    public ConnectLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.connection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                client.warmup(0L);
                ConnectLoginButton.this.session = client.newSession(new CustomTabsCallback(){

                    public void onNavigationEvent(int navigationEvent, Bundle extras) {
                        switch (navigationEvent) {
                            case 6: {
                                ConnectLoginButton.this.setEnabled(true);
                                return;
                            }
                            case 5: {
                                ConnectLoginButton.this.setEnabled(false);
                                return;
                            }
                        }
                    }
                });
                if (ConnectLoginButton.this.session != null) {
                    ConnectLoginButton.this.session.mayLaunchUrl(PRE_FETCH_URL, null, null);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        this.onClickListener = new LoginClickListener();
        this.setOnClickListener(this.onClickListener);
    }

    public void setLaunchCustomTabInNewTask(boolean launchCustomTabInNewTask) {
        this.launchCustomTabInNewTask = launchCustomTabInNewTask;
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    private Uri getAuthorizeUri() {
        Map<String, String> parameters = this.getParameters();
        return ConnectSdk.getAuthorizeUri(parameters, this.browserType);
    }

    @NonNull
    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.getAcrValues() != null && !this.getAcrValues().isEmpty()) {
            parameters.put("acr_values", TextUtils.join((CharSequence)" ", this.getAcrValues()));
        }
        if (this.getLoginScopeTokens() != null && !this.getLoginScopeTokens().isEmpty()) {
            parameters.put("scope", TextUtils.join((CharSequence)" ", this.getLoginScopeTokens()));
        }
        if (this.getClaims() != null && this.getClaims().getClaimsAsSet() != null) {
            try {
                parameters.put("claims", ClaimsParameterFormatter.asJson(this.getClaims()));
            }
            catch (JSONException e) {
                throw new ConnectException("Failed to create claims Json. claims=" + this.getClaims(), e);
            }
        }
        parameters.put("state", this.connectStore.generateSessionStateParam());
        parameters.put("log_session_id", ConnectSdk.getLogSessionId());
        if (!ConnectSdk.isCellularDataNetworkConnected()) {
            parameters.put("prompt", "no_seam");
        }
        if (this.getLoginParameters() != null && !this.getLoginParameters().isEmpty()) {
            parameters.putAll(this.getLoginParameters());
        }
        return parameters;
    }

    private static boolean contextIntentFilterMatchesRedirectUri(Context context) {
        PackageManager manager;
        Uri parse = Uri.parse((String)ConnectSdk.getRedirectUri());
        Intent intent = new Intent().setData(parse);
        ComponentName componentName = intent.resolveActivity(manager = context.getPackageManager());
        if (componentName == null) {
            return false;
        }
        return context.getPackageName().equals(componentName.getPackageName());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        boolean serviceBound = CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)CustomTabsHelper.getPackageNameToUse(this.getContext()), (CustomTabsServiceConnection)this.connection);
        boolean correctIntentFilter = ConnectLoginButton.contextIntentFilterMatchesRedirectUri(this.getContext());
        this.customTabsSupported = serviceBound && correctIntentFilter;
        this.browserType = this.customTabsSupported ? BrowserType.CHROME_CUSTOM_TAB : BrowserType.WEB_VIEW;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.connection != null) {
            this.getContext().unbindService((ServiceConnection)this.connection);
            this.connection = null;
        }
    }

    private void launchWebViewAuthentication() {
        int customLoadingLayout = this.getCustomLoadingLayout();
        if (customLoadingLayout == -1) {
            ConnectSdk.authenticate(this.getActivity(), this.getParameters(), this.getRequestCode());
        } else {
            ConnectSdk.authenticate(this.getActivity(), this.getParameters(), customLoadingLayout, this.getRequestCode());
        }
    }

    private void launchChromeCustomTabAuthentication() {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.session);
        CustomTabsIntent cctIntent = builder.build();
        Intent intent = cctIntent.intent;
        if (this.launchCustomTabInNewTask) {
            intent.setFlags(0x10000000);
        }
        if (Build.VERSION.SDK_INT >= 22) {
            intent.putExtra("android.intent.extra.REFERRER", (Parcelable)Uri.parse((String)("2//" + this.getContext().getPackageName())));
        }
        Uri authorizeUri = this.getAuthorizeUri();
        cctIntent.launchUrl((Context)this.getActivity(), authorizeUri);
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            ConnectSdk.beforeAuthentication();
            if (!ConnectLoginButton.this.customTabsSupported) {
                ConnectLoginButton.this.launchWebViewAuthentication();
            } else {
                ConnectLoginButton.this.launchChromeCustomTabAuthentication();
            }
        }
    }
}

