/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectNotSignedInException;
import com.telenor.connect.ConnectRefreshTokenMissingException;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.utils.ConnectUtils;
import com.telenor.connect.utils.HeadersDateUtil;
import java.util.Date;
import java.util.HashMap;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class ConnectIdService {
    private final ConnectAPI connectApi;
    private final ConnectStore connectStore;
    private final String redirectUrl;
    private final String clientId;
    private ConnectTokens currentTokens;
    private IdToken idToken;

    public ConnectIdService(ConnectStore connectStore, ConnectAPI connectApi, String clientId, String redirectUrl) {
        this.clientId = clientId;
        this.redirectUrl = redirectUrl;
        this.connectApi = connectApi;
        this.connectStore = connectStore;
    }

    public void getValidAccessToken(AccessTokenCallback callback) {
        ConnectTokens connectTokens = this.retrieveTokens();
        if (connectTokens == null) {
            throw new ConnectRefreshTokenMissingException("retrieveTokens() returned null. Tokens are missing. Is the user signed in?");
        }
        if (connectTokens.accessTokenHasExpired()) {
            this.updateTokens(callback);
            return;
        }
        callback.onSuccess(connectTokens.getAccessToken());
    }

    public String getAccessToken() {
        ConnectTokens connectTokens = this.retrieveTokens();
        if (connectTokens == null) {
            return null;
        }
        return connectTokens.getAccessToken();
    }

    public Date getAccessTokenExpirationTime() {
        ConnectTokens connectTokens = this.retrieveTokens();
        if (connectTokens == null) {
            return null;
        }
        return connectTokens.getExpirationDate();
    }

    public void getAccessTokenFromCode(String authCode, final ConnectCallback callback) {
        this.connectApi.getAccessTokens("authorization_code", authCode, this.redirectUrl, this.clientId, new Callback<ConnectTokensTO>(){

            public void success(ConnectTokensTO connectTokensTO, Response response) {
                Date serverTimestamp = HeadersDateUtil.extractDate(response.getHeaders());
                ConnectTokens connectTokens = new ConnectTokens(connectTokensTO, serverTimestamp);
                ConnectIdService.this.connectStore.set(connectTokens);
                ConnectIdService.this.connectStore.clearSessionStateParam();
                ConnectIdService.this.currentTokens = connectTokens;
                ConnectIdService.this.idToken = connectTokens.getIdToken();
                ConnectUtils.sendTokenStateChanged(true);
                if (callback != null) {
                    callback.onSuccess(connectTokens);
                }
            }

            public void failure(RetrofitError error) {
                ConnectIdService.this.clearTokensAndNotify();
                if (callback != null) {
                    HashMap<String, String> errorParams = new HashMap<String, String>();
                    errorParams.put("error", error.toString());
                    callback.onError(errorParams);
                }
            }
        });
    }

    private void clearTokensAndNotify() {
        this.connectStore.clear();
        this.currentTokens = null;
        this.idToken = null;
        ConnectUtils.sendTokenStateChanged(false);
    }

    private String getRefreshToken() {
        ConnectTokens connectTokens = this.retrieveTokens();
        if (connectTokens == null) {
            return null;
        }
        return connectTokens.getRefreshToken();
    }

    public void revokeTokens(Context context) {
        String refreshToken;
        String accessToken = this.getAccessToken();
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            this.revokeAccessToken(accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)(refreshToken = this.getRefreshToken()))) {
            this.revokeRefreshToken(refreshToken);
        }
        this.clearTokensAndNotify();
        this.clearCookies(context);
    }

    private void revokeAccessToken(String accessToken) {
        this.revokeToken(accessToken, "access");
    }

    private void revokeRefreshToken(String refreshToken) {
        this.revokeToken(refreshToken, "refresh");
    }

    private void revokeToken(final String token, final String descriptor) {
        this.connectApi.revokeToken(this.clientId, token, new ResponseCallback(){

            public void success(Response response) {
            }

            public void failure(RetrofitError error) {
                Log.e((String)"ConnectSDK", (String)("Failed to call revoke " + descriptor + " token on API. token=" + token), (Throwable)error);
            }
        });
    }

    private void clearCookies(Context context) {
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
        } else {
            CookieSyncManager.createInstance((Context)context);
            cookieManager.removeAllCookie();
        }
    }

    public void logOut(final Context context) {
        String accessToken = this.getAccessToken();
        String refreshToken = this.getRefreshToken();
        if (accessToken == null || refreshToken == null) {
            Log.w((String)"ConnectSDK", (String)"Trying to log out when user is already logged out.");
            this.revokeTokens(context);
            return;
        }
        this.updateTokens(new AccessTokenCallback(){

            @Override
            public void onSuccess(String accessToken) {
                ConnectIdService.this.callLogOutApiEndpoint(accessToken, new ConnectCallback(){

                    @Override
                    public void onSuccess(Object successData) {
                        ConnectIdService.this.revokeTokens(context);
                    }

                    @Override
                    public void onError(Object errorData) {
                        ConnectIdService.this.revokeTokens(context);
                    }
                });
            }

            @Override
            public void onError(Object errorData) {
                Log.i((String)"ConnectSDK", (String)"Failed to call logOut endpoint. Revoking tokens.");
                ConnectIdService.this.revokeTokens(context);
            }
        });
    }

    private void callLogOutApiEndpoint(final String accessToken, final ConnectCallback callback) {
        String auth = "Bearer " + accessToken;
        this.connectApi.logOut(auth, new ResponseCallback(){

            public void success(Response response) {
                callback.onSuccess(null);
            }

            public void failure(RetrofitError error) {
                Log.e((String)"ConnectSDK", (String)("Failed to call logout with access token on API. accessToken=" + accessToken), (Throwable)error);
                callback.onError(error);
            }
        });
    }

    public void updateTokens(final AccessTokenCallback callback) {
        String refreshToken = this.getRefreshToken();
        if (refreshToken == null) {
            throw new ConnectRefreshTokenMissingException("Refresh token missing, can't update tokens.");
        }
        this.connectApi.refreshAccessTokens("refresh_token", refreshToken, this.clientId, new Callback<ConnectTokensTO>(){

            public void success(ConnectTokensTO connectTokensTO, Response response) {
                Date serverTimestamp = HeadersDateUtil.extractDate(response.getHeaders());
                ConnectTokens connectTokens = new ConnectTokens(connectTokensTO, serverTimestamp);
                ConnectIdService.this.connectStore.update(connectTokens);
                ConnectIdService.this.currentTokens = connectTokens;
                callback.onSuccess(connectTokens.getAccessToken());
            }

            public void failure(RetrofitError error) {
                if (error != null && error.getResponse() != null && error.getResponse().getStatus() >= 400 && error.getResponse().getStatus() < 500) {
                    ConnectIdService.this.clearTokensAndNotify();
                }
                callback.onError(error);
            }
        });
    }

    private ConnectTokens retrieveTokens() {
        if (this.currentTokens == null) {
            this.currentTokens = this.connectStore.get();
        }
        return this.currentTokens;
    }

    public IdToken getIdToken() {
        if (this.idToken == null) {
            this.idToken = this.connectStore.getIdToken();
        }
        return this.idToken;
    }

    public void getUserInfo(Callback<UserInfo> userInfoCallback) throws ConnectNotSignedInException {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            throw new ConnectNotSignedInException("No user is signed in. accessToken=" + accessToken);
        }
        String auth = "Bearer " + accessToken;
        this.connectApi.getUserInfo(auth, userInfoCallback);
    }
}

