/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.id.Claims;
import com.telenor.connect.ui.ConnectButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class ConnectWebViewLoginButton
extends ConnectButton {
    protected static final int NO_CUSTOM_LAYOUT = -1;
    private ArrayList<String> acrValues;
    private Map<String, String> loginParameters;
    private ArrayList<String> loginScopeTokens;
    private int requestCode = 43399;
    private Claims claims;
    private int customLoadingLayout = -1;

    public ConnectWebViewLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.setOnClickListener(new LoginClickListener());
    }

    public ArrayList<String> getAcrValues() {
        return this.acrValues;
    }

    public Map<String, String> getLoginParameters() {
        return this.loginParameters;
    }

    public ArrayList<String> getLoginScopeTokens() {
        return this.loginScopeTokens;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public int getCustomLoadingLayout() {
        return this.customLoadingLayout;
    }

    public void setAcrValues(String ... acrValues) {
        this.acrValues = new ArrayList<String>(Arrays.asList(acrValues));
    }

    public void setAcrValues(ArrayList<String> acrValues) {
        this.acrValues = acrValues;
    }

    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginScopeTokens = new ArrayList<String>(Arrays.asList(scopeTokens));
    }

    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginScopeTokens = scopeTokens;
    }

    public void addLoginParameters(Map<String, String> parameters) {
        this.loginParameters = parameters;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.customLoadingLayout = customLoadingLayout;
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            ConnectSdk.beforeAuthentication();
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (ConnectWebViewLoginButton.this.getAcrValues() != null && !ConnectWebViewLoginButton.this.getAcrValues().isEmpty()) {
                parameters.put("acr_values", TextUtils.join((CharSequence)" ", ConnectWebViewLoginButton.this.getAcrValues()));
            }
            if (ConnectWebViewLoginButton.this.getLoginScopeTokens() != null && !ConnectWebViewLoginButton.this.getLoginScopeTokens().isEmpty()) {
                parameters.put("scope", TextUtils.join((CharSequence)" ", ConnectWebViewLoginButton.this.getLoginScopeTokens()));
            }
            if (ConnectWebViewLoginButton.this.claims != null && ConnectWebViewLoginButton.this.claims.getClaimsAsSet() != null) {
                try {
                    parameters.put("claims", ClaimsParameterFormatter.asJson(ConnectWebViewLoginButton.this.claims));
                }
                catch (JSONException e) {
                    throw new ConnectException("Failed to create claims Json. claims=" + ConnectWebViewLoginButton.this.claims, e);
                }
            }
            if (ConnectWebViewLoginButton.this.getLoginParameters() != null && !ConnectWebViewLoginButton.this.getLoginParameters().isEmpty()) {
                parameters.putAll(ConnectWebViewLoginButton.this.getLoginParameters());
            }
            if (ConnectWebViewLoginButton.this.customLoadingLayout == -1) {
                ConnectSdk.authenticate(ConnectWebViewLoginButton.this.getActivity(), parameters, ConnectWebViewLoginButton.this.requestCode);
            } else {
                ConnectSdk.authenticate(ConnectWebViewLoginButton.this.getActivity(), parameters, ConnectWebViewLoginButton.this.customLoadingLayout, ConnectWebViewLoginButton.this.requestCode);
            }
        }
    }
}

