/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.sms.SmsBroadcastReceiver;
import com.telenor.connect.sms.SmsCursorUtil;
import com.telenor.connect.sms.SmsHandler;
import com.telenor.connect.sms.SmsPinParseUtil;
import com.telenor.connect.ui.Instruction;
import com.telenor.connect.ui.InstructionHandler;
import com.telenor.connect.utils.ConnectUtils;
import com.telenor.connect.utils.JavascriptUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Pattern;

public class ConnectWebViewClient
extends WebViewClient
implements SmsHandler,
InstructionHandler {
    private static final int RACE_CONDITION_DELAY_CHECK_ALREADY_RECEIVED_SMS = 700;
    private static final int READ_RECEIVE_SMS_REQUEST_CODE = 8993;
    private static final String[] SMS_PERMISSIONS = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS"};
    private static long CHECK_FOR_SMS_BACK_IN_TIME_MILLIS = 2500L;
    private static long CHECK_FOR_SMS_TIMEOUT = 60000L;
    private static final int DELAY_HIDE_NATIVE_LOADING_VIEW = 50;
    private static final Pattern TD_HTTPS_PATTERN = Pattern.compile("^https://.*telenordigital.com(?:$|/)");
    private static final String JAVASCRIPT_PROCESSES_INSTRUCTIONS = "javascript:if (document.getElementById('android-instructions') !== null) {window.AndroidInterface.processInstructions(document.getElementById('android-instructions').innerHTML)}";
    private final IntentFilter SMS_FILTER = new IntentFilter("android.provider.Telephony.SMS_RECEIVED");
    private final Activity activity;
    private final View loadingView;
    private final View errorView;
    private final WebView webView;
    private final SmsBroadcastReceiver smsBroadcastReceiver;
    private final ConnectCallback connectCallback;
    private boolean waitingForPinSms = false;
    private boolean instructionsReceived;
    private long pageLoadStarted;
    private Instruction callbackInstruction;
    private List<Instruction> smsPermissionsCallbackInstructions;

    public ConnectWebViewClient(Activity activity, WebView webView, View loadingView, View errorView, ConnectCallback callback) {
        this.webView = webView;
        this.activity = activity;
        this.loadingView = loadingView;
        this.errorView = errorView;
        this.connectCallback = callback;
        this.smsBroadcastReceiver = new SmsBroadcastReceiver(this);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (ConnectSdk.getRedirectUri() != null && url.startsWith(ConnectSdk.getRedirectUri())) {
            ConnectUtils.parseAuthCode(url, this.getOriginalState(), this.connectCallback);
            return true;
        }
        if (ConnectSdk.getPaymentCancelUri() != null && url.startsWith(ConnectSdk.getPaymentCancelUri())) {
            this.activity.setResult(0);
            this.activity.finish();
            return true;
        }
        if (ConnectSdk.getPaymentSuccessUri() != null && url.startsWith(ConnectSdk.getPaymentSuccessUri())) {
            this.activity.setResult(-1);
            this.activity.finish();
            return true;
        }
        return false;
    }

    private String getOriginalState() {
        String url = this.activity.getIntent().getStringExtra("com.telenor.connect.LOGIN_AUTH_URI");
        return Uri.parse((String)url).getQueryParameter("state");
    }

    @TargetApi(value=21)
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        if (!ConnectSdk.isCellularDataNetworkConnected() || ConnectSdk.isCellularDataNetworkDefault()) {
            return null;
        }
        if (this.shouldFetchThroughCellular(request.getUrl().toString())) {
            return this.fetchUrlTroughCellular(request.getUrl().toString());
        }
        return null;
    }

    public boolean shouldFetchThroughCellular(String url) {
        String hostIp;
        WellKnownAPI.WellKnownConfig wellKnownConfig = (WellKnownAPI.WellKnownConfig)this.activity.getIntent().getExtras().get("com.telenor.connect.WELL_KNOWN_CONFIG");
        if (wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            return false;
        }
        if (!wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            for (String urlPrefix : wellKnownConfig.getNetworkAuthenticationTargetUrls()) {
                if (!url.contains(urlPrefix)) continue;
                return true;
            }
            return false;
        }
        try {
            String host = new URL(url).getHost();
            hostIp = InetAddress.getByName(host).getHostAddress();
        }
        catch (MalformedURLException | UnknownHostException e) {
            return false;
        }
        return wellKnownConfig.getNetworkAuthenticationTargetIps().contains(hostIp);
    }

    @TargetApi(value=21)
    public WebResourceResponse fetchUrlTroughCellular(String originalUrl) {
        String newUrl = originalUrl;
        int attempts = 0;
        Network interfaceToUse = ConnectSdk.getCellularNetwork();
        do {
            try {
                HttpURLConnection connection = (HttpURLConnection)interfaceToUse.openConnection(new URL(newUrl));
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                int responseCode = connection.getResponseCode();
                ++attempts;
                if (responseCode != 303 && responseCode != 302 && responseCode != 301) {
                    return new WebResourceResponse(connection.getContentType(), connection.getContentEncoding(), connection.getInputStream());
                }
                newUrl = connection.getHeaderField("Location");
                connection.getInputStream().close();
            }
            catch (IOException e) {
                return null;
            }
            Network network = interfaceToUse = this.shouldFetchThroughCellular(newUrl) ? ConnectSdk.getCellularNetwork() : ConnectSdk.getDefaultNetwork();
        } while (attempts <= 5);
        return null;
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        this.errorView.setVisibility(0);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.errorView.setVisibility(0);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.pageLoadStarted = System.currentTimeMillis();
        this.hideLoadingViewWithDelayIfHEILoading(url);
        this.instructionsReceived = false;
        super.onPageStarted(view, url, favicon);
    }

    private void hideLoadingViewWithDelayIfHEILoading(String url) {
        if (url != null && url.endsWith("/heidetect") && this.loadingView.getVisibility() == 0) {
            this.loadingView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConnectWebViewClient.this.loadingView.setVisibility(8);
                }
            }, 50L);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.loadingView.setVisibility(8);
        if (!this.instructionsReceived && this.shouldCheckPageForInstructions(url)) {
            this.webView.loadUrl(JAVASCRIPT_PROCESSES_INSTRUCTIONS);
        }
    }

    private boolean shouldCheckPageForInstructions(String url) {
        return TD_HTTPS_PATTERN.matcher(url).find();
    }

    @Override
    public void givenInstructions(List<Instruction> instructions) {
        if (this.instructionsReceived) {
            return;
        }
        this.instructionsReceived = true;
        if (this.containsSmsInstruction(instructions)) {
            if (this.hasPermissionToReadSms()) {
                this.executeInstructions(instructions);
            } else {
                this.smsPermissionsCallbackInstructions = instructions;
                this.requestSmsPermissions();
            }
        } else {
            this.executeInstructions(instructions);
        }
    }

    private boolean containsSmsInstruction(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (!instruction.getName().equals("androidSystemCall_getPinFromSms")) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermissionToReadSms() {
        int res1 = this.activity.checkCallingOrSelfPermission("android.permission.RECEIVE_SMS");
        int res2 = this.activity.checkCallingOrSelfPermission("android.permission.READ_SMS");
        return res1 == 0 && res2 == 0;
    }

    private void requestSmsPermissions() {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.activity.requestPermissions(SMS_PERMISSIONS, 8993);
    }

    private void executeInstructions(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (instruction.getName().equals("androidSystemCall_getPinFromSms")) {
                this.getPinFromSms(instruction);
                continue;
            }
            this.runJavascriptInstruction(instruction);
        }
    }

    private void runJavascriptInstruction(final Instruction instruction) {
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                String javascript = JavascriptUtil.getJavascriptString(instruction);
                ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
            }
        });
    }

    private void getPinFromSms(Instruction instruction) {
        this.callbackInstruction = instruction;
        this.waitingForPinSms = true;
        this.subscribeToNewSms();
        this.handleIfSmsAlreadyArrived(instruction);
        this.stopGetPin(CHECK_FOR_SMS_TIMEOUT);
    }

    private void subscribeToNewSms() {
        this.activity.registerReceiver((BroadcastReceiver)this.smsBroadcastReceiver, this.SMS_FILTER);
    }

    private void stopGetPin(long delay) {
        this.webView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ConnectWebViewClient.this.stopGetPin();
            }
        }, delay);
    }

    private void stopGetPin() {
        this.waitingForPinSms = false;
        this.safeUnSubscribeToSmsReceived();
    }

    private void safeUnSubscribeToSmsReceived() {
        try {
            this.activity.unregisterReceiver((BroadcastReceiver)this.smsBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void handleIfSmsAlreadyArrived(final Instruction instruction) {
        this.webView.postDelayed(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = null;
                try {
                    cursor = SmsCursorUtil.getSmsCursor((Context)ConnectWebViewClient.this.activity, ConnectWebViewClient.this.pageLoadStarted - CHECK_FOR_SMS_BACK_IN_TIME_MILLIS);
                }
                catch (SecurityException e) {
                    Log.e((String)"ConnectSDK", (String)"Failed to acquire SMS cursor", (Throwable)e);
                    return;
                }
                if (cursor == null || cursor.getCount() <= 0) {
                    return;
                }
                if (!cursor.moveToFirst()) {
                    return;
                }
                String body = cursor.getString(0);
                ConnectWebViewClient.this.handlePinFromSmsBodyIfPresent(body, instruction);
            }
        }, 700L);
    }

    private synchronized void handlePinFromSmsBodyIfPresent(String body, final Instruction instruction) {
        final String foundPin = SmsPinParseUtil.findPin(body, instruction);
        if (this.waitingForPinSms && foundPin != null && instruction.getPinCallbackName() != null) {
            this.stopGetPin();
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    String javascript = JavascriptUtil.getJavascriptString(instruction.getPinCallbackName(), "'" + foundPin + "'");
                    ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
                }
            });
        }
    }

    @Override
    public void receivedSms(String originatingAddress, String messageBody) {
        this.handlePinFromSmsBodyIfPresent(messageBody, this.callbackInstruction);
    }

    public void onPause() {
        this.safeUnSubscribeToSmsReceived();
    }

    public void onResume() {
        if (this.waitingForPinSms) {
            this.subscribeToNewSms();
            this.handleIfSmsAlreadyArrived(this.callbackInstruction);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode != 8993 || grantResults.length != 2 || grantResults[0] != 0 || grantResults[1] != 0) {
            return;
        }
        this.executeInstructions(this.smsPermissionsCallbackInstructions);
        this.smsPermissionsCallbackInstructions = null;
    }
}

