/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.mobileconnect.operatordiscovery;

import com.google.gson.annotations.SerializedName;
import com.telenor.connect.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import okhttp3.HttpUrl;
import retrofit.Callback;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Query;

public interface OperatorDiscoveryAPI {
    @Headers(value={"Content-Type: application/json"})
    @GET(value="/")
    public void getOperatorDiscoveryResult_ForMccMnc(@Header(value="Authorization") String var1, @Query(value="Redirect_URL") String var2, @Query(value="Identified-MCC") String var3, @Query(value="Identified-MNC") String var4, Callback<OperatorDiscoveryResult> var5);

    public static class OperatorDiscoveryResult {
        @SerializedName(value="subscriber_id")
        private String subscriberId;
        @SerializedName(value="ttl")
        private int ttl;
        @SerializedName(value="response")
        private OperatorInfo operatorInfo;

        public String getEndpoint(String rel) {
            for (OperatorIdApiEndpoint endpoint : this.operatorInfo.apis.operatorIdApi.link) {
                if (!endpoint.usage.equals(rel)) continue;
                return endpoint.href;
            }
            return null;
        }

        public HttpUrl getMobileConnectApiUrl() {
            return HttpUrl.parse((String)this.getEndpoint("authorization"));
        }

        public String getBasePath() {
            for (OperatorIdApiEndpoint endpoint : this.operatorInfo.apis.operatorIdApi.link) {
                if (!endpoint.usage.equals("authorization")) continue;
                return endpoint.href.substring(0, endpoint.href.lastIndexOf("/"));
            }
            return null;
        }

        public String getSubscriberId() {
            return this.subscriberId;
        }

        public String getClientId() {
            return this.operatorInfo.clientId;
        }

        public String getClientSecret() {
            return this.operatorInfo.clientSecret;
        }

        public String getServingOperator() {
            return this.operatorInfo.servingOperator;
        }

        public String getPath(String rel) {
            try {
                return new URL(this.getEndpoint(rel)).getPath();
            }
            catch (MalformedURLException e) {
                throw new ConnectException(e);
            }
        }

        public String getWellKnownEndpoint() {
            String endpoint = this.getEndpoint("openid-configuration");
            if (endpoint != null) {
                return endpoint;
            }
            return this.getBasePath() + "/.well-known/openid-configuration";
        }

        private static class OperatorIdApiEndpoint {
            @SerializedName(value="rel")
            private String usage;
            @SerializedName(value="href")
            private String href;

            private OperatorIdApiEndpoint() {
            }
        }

        private static class OperatorIdApi {
            @SerializedName(value="link")
            private List<OperatorIdApiEndpoint> link;

            private OperatorIdApi() {
            }
        }

        private static class OperatorApi {
            @SerializedName(value="operatorid")
            private OperatorIdApi operatorIdApi;

            private OperatorApi() {
            }
        }

        private static class OperatorInfo {
            @SerializedName(value="country")
            private String country;
            @SerializedName(value="currency")
            private String currency;
            @SerializedName(value="client_id")
            private String clientId;
            @SerializedName(value="client_name")
            private String clientName;
            @SerializedName(value="client_secret")
            private String clientSecret;
            @SerializedName(value="serving_operator")
            private String servingOperator;
            @SerializedName(value="apis")
            private OperatorApi apis;

            private OperatorInfo() {
            }
        }
    }
}

