/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.Toast;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdkProfile;
import com.telenor.connect.R;
import com.telenor.connect.SdkProfile;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.ui.ConnectActivity;
import com.telenor.connect.ui.ConnectWebFragment;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.Validator;
import com.telenor.mobileconnect.MobileConnectSdkProfile;
import com.telenor.mobileconnect.SimCardStateChangedBroadcastReceiver;
import com.telenor.mobileconnect.operatordiscovery.OperatorDiscoveryConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.HttpUrl;
import retrofit.Callback;

public final class ConnectSdk {
    private static ArrayList<Locale> sLocales;
    private static String sPaymentCancelUri;
    private static String sPaymentSuccessUri;
    private static SdkProfile sdkProfile;
    private static ConnectivityManager connectivityManager;
    private static volatile Network cellularNetwork;
    private static volatile Network defaultNetwork;
    private static ConnectStore connectStore;
    public static final String CLIENT_ID_PROPERTY = "com.telenor.connect.CLIENT_ID";
    public static final String CONFIDENTIAL_CLIENT_PROPERTY = "com.telenor.connect.CONFIDENTIAL_CLIENT";
    public static final String PAYMENT_CANCEL_URI_PROPERTY = "com.telenor.connect.PAYMENT_CANCEL_URI";
    public static final String PAYMENT_SUCCESS_URI_PROPERTY = "com.telenor.connect.PAYMENT_SUCCESS_URI";
    public static final String REDIRECT_URI_PROPERTY = "com.telenor.connect.REDIRECT_URI";
    public static final String USE_STAGING_PROPERTY = "com.telenor.connect.USE_STAGING";
    public static final String ACTION_LOGIN_STATE_CHANGED = "com.telenor.connect.ACTION_LOGIN_STATE_CHANGED";
    public static final String EXTRA_PAYMENT_LOCATION = "com.telenor.connect.EXTRA_PAYMENT_LOCATION";
    public static final String EXTRA_CONNECT_TOKENS = "com.telenor.connect.EXTRA_CONNECT_TOKENS";
    public static final int MAX_REDIRECTS_TO_FOLLOW_FOR_HE = 5;

    public static SdkProfile getSdkProfile() {
        Validator.sdkInitialized();
        return sdkProfile;
    }

    public static synchronized void authenticate(Activity activity, int requestCode, String ... scopeTokens) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scope", TextUtils.join((CharSequence)" ", (Object[])scopeTokens));
        ConnectSdk.authenticate(activity, parameters, requestCode);
    }

    public static synchronized void authenticate(final Activity activity, final Map<String, String> parameters, final int requestCode) {
        Validator.sdkInitialized();
        sdkProfile.onStartAuthorization(parameters, new SdkProfile.OnStartAuthorizationCallback(){

            @Override
            public void onSuccess() {
                Intent intent = ConnectSdk.getAuthIntent(parameters);
                activity.startActivityForResult(intent, requestCode);
            }

            @Override
            public void onError() {
                ConnectSdk.showAuthCancelMessage(activity);
            }
        });
    }

    private static Intent getAuthIntent(Map<String, String> parameters) {
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.setAction("com.telenor.connect.LOGIN_ACTION");
        String mccMnc = ConnectSdk.getMccMnc();
        WellKnownAPI.WellKnownConfig wellKnownConfig = sdkProfile.getWellKnownConfig();
        if (!(TextUtils.isEmpty((CharSequence)mccMnc) || wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty())) {
            parameters.put("login_hint", String.format("MCCMNC:%s", mccMnc));
        }
        String url = ConnectSdk.getAuthorizeUri(parameters, BrowserType.WEB_VIEW).toString();
        intent.putExtra("com.telenor.connect.LOGIN_AUTH_URI", url);
        intent.putExtra("com.telenor.connect.WELL_KNOWN_CONFIG", (Parcelable)wellKnownConfig);
        return intent;
    }

    public static synchronized void authenticate(final Activity activity, final Map<String, String> parameters, final int customLoadingLayout, final int requestCode) {
        Validator.sdkInitialized();
        sdkProfile.onStartAuthorization(parameters, new SdkProfile.OnStartAuthorizationCallback(){

            @Override
            public void onSuccess() {
                Intent intent = ConnectSdk.getAuthIntent(parameters);
                intent.putExtra("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", customLoadingLayout);
                activity.startActivityForResult(intent, requestCode);
            }

            @Override
            public void onError() {
                ConnectSdk.showAuthCancelMessage(activity);
            }
        });
    }

    private static void showAuthCancelMessage(Activity activity) {
        Toast.makeText((Context)activity, (int)R.string.com_telenor_authorization_cancelled, (int)0).show();
    }

    public static Fragment getAuthFragment(Map<String, String> parameters) {
        Validator.sdkInitialized();
        ConnectWebFragment fragment = new ConnectWebFragment();
        Intent authIntent = ConnectSdk.getAuthIntent(parameters);
        String action = authIntent.getAction();
        Bundle bundle = new Bundle(authIntent.getExtras());
        bundle.putString("com.telenor.connect.ACTION_ARGUMENT", action);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        return fragment;
    }

    public static synchronized void getValidAccessToken(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        sdkProfile.getConnectIdService().getValidAccessToken(callback);
    }

    public static synchronized String getAccessToken() {
        Validator.sdkInitialized();
        if (sdkProfile.getConnectIdService() != null) {
            return sdkProfile.getConnectIdService().getAccessToken();
        }
        return null;
    }

    public static synchronized Date getAccessTokenExpirationTime() {
        Validator.sdkInitialized();
        return sdkProfile.getConnectIdService().getAccessTokenExpirationTime();
    }

    public static synchronized void getAccessTokenFromCode(String code, ConnectCallback callback) {
        Validator.sdkInitialized();
        sdkProfile.getConnectIdService().getAccessTokenFromCode(code, callback);
    }

    public static synchronized Uri getAuthorizeUri(Map<String, String> parameters, BrowserType browserType) {
        if (ConnectSdk.getClientId() == null) {
            throw new ConnectException("Client ID not specified in application manifest.");
        }
        if (ConnectSdk.getRedirectUri() == null) {
            throw new ConnectException("Redirect URI not specified in application manifest.");
        }
        if (parameters.get("scope") == null || parameters.get("scope").isEmpty()) {
            throw new IllegalStateException("Cannot log in without scope tokens.");
        }
        return sdkProfile.getAuthorizeUri(parameters, ConnectSdk.getUiLocales(), browserType);
    }

    public static HttpUrl getConnectApiUrl() {
        Validator.sdkInitialized();
        return sdkProfile.getApiUrl();
    }

    public static Context getContext() {
        Validator.sdkInitialized();
        return sdkProfile.getContext();
    }

    public static String getClientId() {
        Validator.sdkInitialized();
        return sdkProfile.getClientId();
    }

    public static ArrayList<Locale> getLocales() {
        Validator.sdkInitialized();
        return sLocales;
    }

    public static String getPaymentCancelUri() {
        Validator.sdkInitialized();
        return sPaymentCancelUri;
    }

    public static String getPaymentSuccessUri() {
        Validator.sdkInitialized();
        return sPaymentSuccessUri;
    }

    public static String getRedirectUri() {
        Validator.sdkInitialized();
        return sdkProfile.getRedirectUri();
    }

    private static ArrayList<String> getUiLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        if (ConnectSdk.getLocales() != null && !ConnectSdk.getLocales().isEmpty()) {
            for (Locale locale : ConnectSdk.getLocales()) {
                locales.add(locale.toString());
                locales.add(locale.getLanguage());
            }
        }
        locales.add(Locale.getDefault().toString());
        locales.add(Locale.getDefault().getLanguage());
        return locales;
    }

    public static void initializePayment(Context context, String transactionLocation) {
        Validator.sdkInitialized();
        if (ConnectSdk.getPaymentSuccessUri() == null || ConnectSdk.getPaymentCancelUri() == null) {
            throw new ConnectException("Payment success or cancel URI not specified in applicationmanifest.");
        }
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.putExtra(EXTRA_PAYMENT_LOCATION, transactionLocation);
        intent.setAction("com.telenor.connect.PAYMENT_ACTION");
        Activity activity = (Activity)context;
        activity.startActivityForResult(intent, 1);
    }

    public static String getExpectedIssuer() {
        Validator.sdkInitialized();
        return sdkProfile.getExpectedIssuer();
    }

    public static List<String> getExpectedAudiences() {
        Validator.sdkInitialized();
        return sdkProfile.getExpectedAudiences();
    }

    public static synchronized boolean isConfidentialClient() {
        Validator.sdkInitialized();
        return sdkProfile.isConfidentialClient();
    }

    public static synchronized boolean isInitialized() {
        return sdkProfile != null;
    }

    public static void logout() {
        Validator.sdkInitialized();
        sdkProfile.logout();
    }

    public static synchronized void sdkInitialize(Context context) {
        if (ConnectSdk.isInitialized()) {
            return;
        }
        Validator.notNull(context, "context");
        ConnectSdkProfile profile = ConnectSdk.loadConnectConfig(context);
        sdkProfile = profile;
        connectStore = new ConnectStore(ConnectSdk.getContext());
        profile.setConnectIdService(new ConnectIdService(connectStore, RestHelper.getConnectApi(ConnectSdk.getConnectApiUrl().toString()), profile.getClientId(), profile.getRedirectUri()));
        ConnectSdk.initializeCommonComponents();
    }

    public static String getMccMnc() {
        TelephonyManager tel = (TelephonyManager)ConnectSdk.getContext().getSystemService("phone");
        return tel.getNetworkOperator();
    }

    public static void setLocales(Locale ... locales) {
        sLocales = new ArrayList<Locale>(Arrays.asList(locales));
    }

    public static void setLocales(ArrayList<Locale> locales) {
        sLocales = locales;
    }

    public static void updateTokens(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        sdkProfile.getConnectIdService().updateTokens(callback);
    }

    private static ConnectSdkProfile loadConnectConfig(Context context) {
        Object paymentSuccessUriObject;
        Object paymentCancelUriObject;
        Object redirectUriObject;
        ApplicationInfo ai = ConnectSdk.getApplicationInfo(context);
        if (ai == null || ai.metaData == null) {
            throw new ConnectException("No application metadata was found.");
        }
        ConnectSdkProfile profile = new ConnectSdkProfile(context, ConnectSdk.fetchBooleanProperty(ai, USE_STAGING_PROPERTY), ConnectSdk.fetchBooleanProperty(ai, CONFIDENTIAL_CLIENT_PROPERTY));
        Object clientIdObject = ai.metaData.get(CLIENT_ID_PROPERTY);
        if (clientIdObject instanceof String) {
            String clientIdString = (String)clientIdObject;
            profile.setClientId(clientIdString);
        }
        if ((redirectUriObject = ai.metaData.get(REDIRECT_URI_PROPERTY)) instanceof String) {
            profile.setRedirectUri((String)redirectUriObject);
        }
        if ((paymentCancelUriObject = ai.metaData.get(PAYMENT_CANCEL_URI_PROPERTY)) instanceof String) {
            String paymentCancelUriString;
            sPaymentCancelUri = paymentCancelUriString = (String)paymentCancelUriObject;
        }
        if ((paymentSuccessUriObject = ai.metaData.get(PAYMENT_SUCCESS_URI_PROPERTY)) instanceof String) {
            String paymentSuccessUriString;
            sPaymentSuccessUri = paymentSuccessUriString = (String)paymentSuccessUriObject;
        }
        return profile;
    }

    private static ApplicationInfo getApplicationInfo(Context context) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static boolean fetchBooleanProperty(ApplicationInfo appInfo, String propertyName) {
        if (appInfo == null) {
            return false;
        }
        if (appInfo.metaData == null) {
            return false;
        }
        Object booleanPropertyObject = appInfo.metaData.get(propertyName);
        if (!(booleanPropertyObject instanceof Boolean)) {
            return false;
        }
        return (Boolean)booleanPropertyObject;
    }

    public static WellKnownAPI.WellKnownConfig getWellKnownConfig() {
        Validator.sdkInitialized();
        return sdkProfile.getWellKnownConfig();
    }

    @Deprecated
    public static String getSubjectId() {
        Validator.sdkInitialized();
        IdToken idToken = sdkProfile.getConnectIdService().getIdToken();
        return idToken != null ? idToken.getSubject() : null;
    }

    public static IdToken getIdToken() {
        Validator.sdkInitialized();
        return sdkProfile.getConnectIdService().getIdToken();
    }

    public static void getUserInfo(Callback<UserInfo> userInfoCallback) {
        Validator.sdkInitialized();
        sdkProfile.getConnectIdService().getUserInfo(userInfoCallback);
    }

    public static boolean hasValidRedirectUrlCall(Intent intent) {
        Uri data = intent.getData();
        if (data == null) {
            return false;
        }
        boolean startsWithCorrect = data.toString().startsWith(ConnectSdk.getRedirectUri());
        if (!startsWithCorrect) {
            return false;
        }
        String state = data.getQueryParameter("state");
        String originalState = connectStore.getSessionStateParam();
        if (originalState != null && !originalState.equals(state)) {
            return false;
        }
        String code = data.getQueryParameter("code");
        return code != null && !code.isEmpty();
    }

    public static void handleRedirectUriCallIfPresent(Intent intent, ConnectCallback callback) {
        if (!ConnectSdk.hasValidRedirectUrlCall(intent)) {
            return;
        }
        String code = ConnectSdk.getCodeFromIntent(intent);
        ConnectSdk.getAccessTokenFromCode(code, callback);
    }

    public static String getCodeFromIntent(@NonNull Intent intent) {
        Uri data = intent.getData();
        return data.getQueryParameter("code");
    }

    public static synchronized void sdkInitializeMobileConnect(Context context, OperatorDiscoveryConfig operatorDiscoveryConfig) {
        if (ConnectSdk.isInitialized()) {
            return;
        }
        sdkProfile = new MobileConnectSdkProfile(context, operatorDiscoveryConfig, ConnectSdk.fetchBooleanProperty(ConnectSdk.getApplicationInfo(context), CONFIDENTIAL_CLIENT_PROPERTY));
        context.registerReceiver((BroadcastReceiver)SimCardStateChangedBroadcastReceiver.getReceiver(), SimCardStateChangedBroadcastReceiver.getIntentFilter());
        ConnectSdk.initializeCommonComponents();
    }

    public static synchronized void sdkReinitializeMobileConnect() {
        if (!ConnectSdk.isInitialized()) {
            return;
        }
        MobileConnectSdkProfile profile = (MobileConnectSdkProfile)sdkProfile;
        profile.deInitialize();
    }

    private static synchronized void initializeCommonComponents() {
        connectivityManager = (ConnectivityManager)ConnectSdk.getContext().getSystemService("connectivity");
        if (connectivityManager == null || Build.VERSION.SDK_INT < 21) {
            return;
        }
        ConnectSdk.initalizeCellularNetwork();
        ConnectSdk.initalizeDefaultNetwork();
    }

    public static boolean isCellularDataNetworkConnected() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = null;
        if (Build.VERSION.SDK_INT < 21) {
            networkInfo = connectivityManager.getNetworkInfo(0);
        } else {
            if (cellularNetwork == null) {
                return false;
            }
            networkInfo = connectivityManager.getNetworkInfo(cellularNetwork);
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isCellularDataNetworkDefault() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 0;
    }

    @TargetApi(value=21)
    private static void initalizeCellularNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    cellularNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            cellularNetwork = null;
        }
    }

    @TargetApi(value=21)
    private static void initalizeDefaultNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    defaultNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            defaultNetwork = null;
        }
    }

    @TargetApi(value=21)
    public static Network getCellularNetwork() {
        return cellularNetwork;
    }

    @TargetApi(value=21)
    public static Network getDefaultNetwork() {
        return defaultNetwork;
    }
}

