/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.headerenrichment;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.headerenrichment.GetHeaderEnrichmentGifTask;
import com.telenor.connect.headerenrichment.HeTokenCallback;
import com.telenor.connect.headerenrichment.HeTokenResponse;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.utils.ConnectUrlHelper;
import java.util.Date;
import java.util.Map;

public class HeLogic {
    private static final long HE_TOKEN_TIMEOUT_MILLISECONDS = 10000L;
    private static final boolean canNotDirectNetworkTraffic = Build.VERSION.SDK_INT < 21;
    private static boolean heTokenSuccess = true;
    private static HeTokenCallback heTokenCallback;
    private static boolean isHeTokenRequestOngoing;
    private static HeTokenResponse heTokenResponse;
    private static ConnectivityManager connectivityManager;
    private static volatile Network cellularNetwork;
    private static volatile Network defaultNetwork;

    public static void initializeNetworks(Context context, boolean useStaging) {
        boolean connectivityManagerAvailableAndNotTooOldAndroid;
        connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        boolean bl = connectivityManagerAvailableAndNotTooOldAndroid = connectivityManager != null && Build.VERSION.SDK_INT >= 21;
        if (connectivityManagerAvailableAndNotTooOldAndroid) {
            HeLogic.initializeCellularNetwork(useStaging);
            HeLogic.initializeDefaultNetwork();
        }
    }

    @TargetApi(value=21)
    private static void initializeCellularNetwork(final boolean useStaging) {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    boolean noSignedInUser;
                    cellularNetwork = network;
                    boolean bl = noSignedInUser = ConnectSdk.getAccessToken() == null;
                    if (noSignedInUser) {
                        HeLogic.initializeHeaderEnrichment(useStaging, ConnectSdk.getLogSessionId());
                    }
                }
            });
        }
        catch (SecurityException e) {
            cellularNetwork = null;
        }
    }

    private static void initializeHeaderEnrichment(boolean useStaging, String logSessionId) {
        if (canNotDirectNetworkTraffic) {
            return;
        }
        String url = ConnectUrlHelper.getHeApiUrl(useStaging, logSessionId);
        GetHeaderEnrichmentGifTask getGifTask = new GetHeaderEnrichmentGifTask(url, 10000L){

            @Override
            protected void onPreExecute() {
                isHeTokenRequestOngoing = true;
                super.onPreExecute();
            }

            protected void onPostExecute(HeTokenResponse heToken) {
                HeLogic.handleHeTokenResult(heToken);
            }

            protected void onCancelled(HeTokenResponse heToken) {
                HeLogic.handleHeTokenResult(heToken);
            }
        };
        getGifTask.execute(new Void[0]);
    }

    @TargetApi(value=21)
    private static void initializeDefaultNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    defaultNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            defaultNetwork = null;
        }
    }

    public static void handleHeToken(Map<String, String> parameters, ShowLoadingCallback showLoadingCallback, HeTokenCallback heTokenCallback, String logSessionId, boolean useStaging) {
        boolean tokenIsExpired;
        boolean authenticateNow;
        boolean finishedUnSuccessfully = !heTokenSuccess && !isHeTokenRequestOngoing;
        boolean promptBlocksUseOfHe = parameters.containsKey("prompt") && "no_seam".equals(parameters.get("prompt"));
        boolean bl = authenticateNow = finishedUnSuccessfully || promptBlocksUseOfHe || canNotDirectNetworkTraffic;
        if (authenticateNow) {
            HeLogic.callCallbacks(showLoadingCallback, heTokenCallback);
            return;
        }
        if (isHeTokenRequestOngoing) {
            HeLogic.setFutureHeTokenCallback(parameters, showLoadingCallback, heTokenCallback, logSessionId, useStaging);
            return;
        }
        boolean heWasNeverInitialized = heTokenSuccess && heTokenResponse == null;
        boolean bl2 = tokenIsExpired = heTokenResponse != null && new Date().after(heTokenResponse.getExpiration());
        if (heWasNeverInitialized || tokenIsExpired) {
            HeLogic.setFutureHeTokenCallback(parameters, showLoadingCallback, heTokenCallback, logSessionId, useStaging);
            HeLogic.initializeHeaderEnrichment(useStaging, logSessionId);
            return;
        }
        HeLogic.callCallbacks(showLoadingCallback, heTokenCallback);
    }

    private static void callCallbacks(ShowLoadingCallback showLoadingCallback, HeTokenCallback heTokenCallback) {
        if (showLoadingCallback != null) {
            showLoadingCallback.stop();
        }
        heTokenCallback.done();
    }

    private static void setFutureHeTokenCallback(final Map<String, String> parameters, final ShowLoadingCallback showLoadingCallback, final HeTokenCallback heTokenCallback, final String logSessionId, final boolean useStaging) {
        HeLogic.heTokenCallback = new HeTokenCallback(){

            @Override
            public void done() {
                heTokenCallback = null;
                HeLogic.handleHeToken(parameters, showLoadingCallback, heTokenCallback, logSessionId, useStaging);
            }
        };
    }

    private static void handleHeTokenResult(HeTokenResponse heTokenResponse) {
        isHeTokenRequestOngoing = false;
        HeLogic.heTokenResponse = heTokenResponse;
        boolean bl = heTokenSuccess = heTokenResponse != null;
        if (heTokenCallback != null) {
            heTokenCallback.done();
        }
    }

    public static boolean failedToGetToken() {
        return !heTokenSuccess || heTokenResponse == null;
    }

    public static HeTokenResponse getHeTokenResponse() {
        return heTokenResponse;
    }

    public static boolean isCellularDataNetworkConnected() {
        NetworkInfo networkInfo;
        if (connectivityManager == null) {
            return false;
        }
        if (canNotDirectNetworkTraffic) {
            networkInfo = HeLogic.getCellularNetworkInfo();
        } else {
            if (cellularNetwork == null) {
                return false;
            }
            networkInfo = connectivityManager.getNetworkInfo(cellularNetwork);
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static NetworkInfo getCellularNetworkInfo() {
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getNetworkInfo(0);
    }

    public static boolean isCellularDataNetworkDefault() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 0;
    }

    public static NetworkInfo getActiveNetworkInfo() {
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    @TargetApi(value=21)
    public static Network getCellularNetwork() {
        return cellularNetwork;
    }

    @TargetApi(value=21)
    public static Network getDefaultNetwork() {
        return defaultNetwork;
    }
}

