/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.ui.ConnectWebViewLoginButton;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.CustomTabsHelper;

public class ConnectCustomTabLoginButton
extends ConnectWebViewLoginButton {
    private final CustomTabsServiceConnection connection = new CustomTabsServiceConnection(){

        public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient client) {
            client.warmup(0L);
            CustomTabsSession session = client.newSession(null);
            ConnectCustomTabLoginButton.this.session = session;
            session.mayLaunchUrl(ConnectUrlHelper.getPreFetchUrl(), null, null);
        }

        public void onServiceDisconnected(ComponentName name) {
            ConnectCustomTabLoginButton.this.session = null;
        }
    };
    private boolean customTabsSupported = false;
    private boolean serviceBound = false;
    private BrowserType browserType;
    private CustomTabsSession session;

    public ConnectCustomTabLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    protected void authenticate() {
        this.setEnabled(false);
        if (!this.customTabsSupported) {
            super.authenticate();
            return;
        }
        ConnectSdk.authenticate(this.session, this.getParameters(), this.browserType, this.getActivity(), this.getShowLoadingCallback());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        String packageNameToUse = CustomTabsHelper.getPackageNameToUse(this.getContext());
        if (TextUtils.isEmpty((CharSequence)packageNameToUse)) {
            return;
        }
        this.serviceBound = CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)packageNameToUse, (CustomTabsServiceConnection)this.connection);
        boolean correctIntentFilter = ConnectCustomTabLoginButton.contextIntentFilterMatchesRedirectUri(this.getContext());
        this.customTabsSupported = this.serviceBound && correctIntentFilter;
        this.browserType = this.customTabsSupported ? BrowserType.CHROME_CUSTOM_TAB : BrowserType.WEB_VIEW;
    }

    private static boolean contextIntentFilterMatchesRedirectUri(Context context) {
        PackageManager manager;
        Uri parse = Uri.parse((String)ConnectSdk.getRedirectUri());
        Intent intent = new Intent().setData(parse);
        ComponentName componentName = intent.resolveActivity(manager = context.getPackageManager());
        if (componentName == null) {
            return false;
        }
        return context.getPackageName().equals(componentName.getPackageName());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.serviceBound) {
            this.getContext().unbindService((ServiceConnection)this.connection);
            this.serviceBound = false;
        }
        this.session = null;
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Intent intent = this.getActivity().getIntent();
        if (ConnectSdk.hasErrorRedirectUrlCall(intent)) {
            ConnectSdk.setRandomLogSessionId();
        }
        boolean ongoingAuth = intent != null && ConnectSdk.hasValidRedirectUrlCall(intent);
        boolean enableButton = !ongoingAuth;
        this.setEnabled(enableButton);
    }
}

