/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.IdTokenDeserializer;
import java.util.concurrent.TimeUnit;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class RestHelper {
    public static ConnectAPI getConnectApi(String endpoint) {
        OkHttpClient httpClient = new OkHttpClient();
        httpClient.setConnectTimeout(10L, TimeUnit.SECONDS);
        httpClient.setReadTimeout(10L, TimeUnit.SECONDS);
        httpClient.setWriteTimeout(10L, TimeUnit.SECONDS);
        Gson gson = new GsonBuilder().registerTypeAdapter(IdToken.class, (Object)new IdTokenDeserializer()).create();
        RequestInterceptor connectRetroFitInterceptor = new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Accept", "application/json");
            }
        };
        return (ConnectAPI)new RestAdapter.Builder().setClient((Client)new OkClient(httpClient)).setEndpoint(endpoint).setRequestInterceptor(connectRetroFitInterceptor).setLogLevel(RestAdapter.LogLevel.FULL).setConverter((Converter)new GsonConverter(gson)).build().create(ConnectAPI.class);
    }
}

