/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.ui.ConnectWebViewLoginButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import com.telenor.connect.utils.Validator;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class ConnectLoginButton
extends ConnectWebViewLoginButton {
    private static final Uri PRE_FETCH_URL = Uri.parse((String)ConnectSdk.getConnectApiUrl().newBuilder().addPathSegment("id").addPathSegment("android-sdk-prefetch-static-resources").build().uri().toString());
    private View.OnClickListener onClickListener;
    private CustomTabsServiceConnection connection;
    private boolean customTabsSupported = false;
    private BrowserType browserType;

    public ConnectLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.connection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                client.warmup(0L);
                client.newSession(null).mayLaunchUrl(PRE_FETCH_URL, null, null);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        boolean serviceBound = CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)"com.android.chrome", (CustomTabsServiceConnection)this.connection);
        boolean correctIntentFilter = ConnectLoginButton.contextIntentFilterMatchesRedirectUri(this.getContext());
        this.customTabsSupported = serviceBound && correctIntentFilter;
        this.browserType = this.customTabsSupported ? BrowserType.CHROME_CUSTOM_TAB : BrowserType.WEB_VIEW;
        this.onClickListener = new LoginClickListener();
        this.setOnClickListener(this.onClickListener);
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    private Uri getAuthorizeUriAndSetLastAuthState() {
        Map<String, String> parameters = this.getParameters();
        return ConnectSdk.getAuthorizeUriAndSetLastAuthState(parameters, this.browserType);
    }

    @NonNull
    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.getAcrValues() != null && !this.getAcrValues().isEmpty()) {
            parameters.put("acr_values", TextUtils.join((CharSequence)" ", this.getAcrValues()));
        }
        if (this.getLoginScopeTokens() != null && !this.getLoginScopeTokens().isEmpty()) {
            parameters.put("scope", TextUtils.join((CharSequence)" ", this.getLoginScopeTokens()));
        }
        if (this.getClaims() != null && this.getClaims().getClaimsAsSet() != null) {
            try {
                parameters.put("claims", ClaimsParameterFormatter.asJson(this.getClaims()));
            }
            catch (JSONException e) {
                throw new ConnectException("Failed to create claims Json. claims=" + this.getClaims(), e);
            }
        }
        if (this.getLoginParameters() != null && !this.getLoginParameters().isEmpty()) {
            parameters.putAll(this.getLoginParameters());
        }
        return parameters;
    }

    private static boolean contextIntentFilterMatchesRedirectUri(Context context) {
        PackageManager manager;
        Uri parse = Uri.parse((String)ConnectSdk.getRedirectUri());
        Intent intent = new Intent().setData(parse);
        ComponentName componentName = intent.resolveActivity(manager = context.getPackageManager());
        if (componentName == null) {
            return false;
        }
        return context.getClass().getName().equals(componentName.getClassName());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.connection != null) {
            this.getContext().unbindService((ServiceConnection)this.connection);
            this.connection = null;
        }
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            if (!ConnectLoginButton.this.customTabsSupported) {
                int customLoadingLayout = ConnectLoginButton.this.getCustomLoadingLayout();
                if (customLoadingLayout == -1) {
                    ConnectSdk.authenticate(ConnectLoginButton.this.getActivity(), ConnectLoginButton.this.getParameters(), ConnectLoginButton.this.getRequestCode());
                } else {
                    ConnectSdk.authenticate(ConnectLoginButton.this.getActivity(), ConnectLoginButton.this.getParameters(), customLoadingLayout, ConnectLoginButton.this.getRequestCode());
                }
                return;
            }
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent intent = builder.build();
            intent.intent.setFlags(0x10000000);
            intent.launchUrl(ConnectLoginButton.this.getActivity(), ConnectLoginButton.this.getAuthorizeUriAndSetLastAuthState());
        }
    }
}

