/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.id.IdToken;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TokenStore {
    private static final String PREFERENCE_KEY_CONNECT_TOKENS = "CONNECT_TOKENS";
    private static final String PREFERENCE_KEY_ID_TOKEN = "ID_TOKEN";
    private static final String PREFERENCES_FILE = "com.telenor.connect.PREFERENCES_FILE";
    private static final Gson preferencesGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new DateDeserializer()).create();
    private final Context context;

    public TokenStore(Context context) {
        this.context = context;
    }

    public void set(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        String jsonIdToken = preferencesGson.toJson((Object)connectTokens.getIdToken());
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).putString(PREFERENCE_KEY_ID_TOKEN, jsonIdToken).apply();
    }

    public void update(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).apply();
    }

    public ConnectTokens get() {
        String connectTokensJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_CONNECT_TOKENS, null);
        return (ConnectTokens)preferencesGson.fromJson(connectTokensJson, ConnectTokens.class);
    }

    public void clear() {
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().clear().apply();
    }

    public IdToken getIdToken() {
        String idTokenJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_ID_TOKEN, null);
        return (IdToken)preferencesGson.fromJson(idTokenJson, IdToken.class);
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            String date = je.getAsString();
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(date);
            }
            catch (ParseException parseException) {
                try {
                    return new SimpleDateFormat("MMM d, y h:mm:ss").parse(date);
                }
                catch (ParseException parseException2) {
                    try {
                        return new SimpleDateFormat("MMM d, y h:mm:ss", Locale.ENGLISH).parse(date);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return DateFormat.getDateTimeInstance(2, 2).parse(date);
                        }
                        catch (ParseException parseException4) {
                            try {
                                return DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH).parse(date);
                            }
                            catch (ParseException parseException5) {
                                throw new JsonParseException("Invalid date:" + date);
                            }
                        }
                    }
                }
            }
        }
    }
}

