/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.mobileconnect;

import android.content.Context;
import android.net.Uri;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.telenor.connect.AbstractSdkProfile;
import com.telenor.connect.SdkProfile;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.id.TokenStore;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.Validator;
import com.telenor.mobileconnect.OperatorDiscoveryConfigStore;
import com.telenor.mobileconnect.id.MobileConnectAPI;
import com.telenor.mobileconnect.operatordiscovery.OperatorDiscoveryAPI;
import com.telenor.mobileconnect.operatordiscovery.OperatorDiscoveryConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.HttpUrl;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class MobileConnectSdkProfile
extends AbstractSdkProfile {
    private OperatorDiscoveryConfig operatorDiscoveryConfig;
    private volatile OperatorDiscoveryAPI.OperatorDiscoveryResult operatorDiscoveryResult;
    private final OperatorDiscoveryConfigStore lastSeenStore;
    private String lastAuthNonce;

    public MobileConnectSdkProfile(Context context, OperatorDiscoveryConfig operatorDiscoveryConfig, boolean confidentialClient) {
        super(context, confidentialClient);
        this.operatorDiscoveryConfig = operatorDiscoveryConfig;
        this.lastSeenStore = new OperatorDiscoveryConfigStore(context);
        OperatorDiscoveryAPI.OperatorDiscoveryResult lastSeen = this.lastSeenStore.get();
        if (lastSeen != null) {
            this.operatorDiscoveryResult = lastSeen;
            this.setConnectIdService(this.createConnectIdService());
        }
    }

    @Override
    public HttpUrl getApiUrl() {
        String host = this.operatorDiscoveryResult.getMobileConnectApiUrl().host();
        HttpUrl.Builder builder = new HttpUrl.Builder();
        builder.scheme(this.operatorDiscoveryResult.getMobileConnectApiUrl().scheme()).host(host);
        for (String seg : this.operatorDiscoveryResult.getMobileConnectApiUrl().pathSegments()) {
            builder.addPathSegment(seg);
        }
        return builder.build();
    }

    @Override
    public String getClientId() {
        return this.operatorDiscoveryResult.getClientId();
    }

    @Override
    public String getClientSecret() {
        return this.operatorDiscoveryResult.getClientSecret();
    }

    @Override
    public String getRedirectUri() {
        return this.operatorDiscoveryConfig.getOperatorDiscoveryRedirectUri();
    }

    @Override
    public String getExpectedIssuer() {
        if (this.getWellKnownConfig() != null) {
            return this.getWellKnownConfig().getIssuer();
        }
        return this.operatorDiscoveryResult.getBasePath();
    }

    @Override
    public List<String> getExpectedAudiences() {
        return new ArrayList<String>(Arrays.asList(this.getClientId()));
    }

    @Override
    public Uri getAuthorizeUri(Map<String, String> parameters, List<String> locales) {
        Uri.Builder builder = ConnectUrlHelper.getAuthorizeUriStem(parameters, this.getClientId(), this.getRedirectUri(), locales, this.getApiUrl()).buildUpon();
        for (String pathSeg : this.getApiUrl().pathSegments()) {
            builder.appendPath(pathSeg);
        }
        return builder.build();
    }

    @Override
    public void onStartAuthorization(Map<String, String> parameters, final SdkProfile.OnStartAuthorizationCallback callback) {
        super.onStartAuthorization(parameters, callback);
        this.lastAuthNonce = UUID.randomUUID().toString();
        parameters.put("nonce", this.lastAuthNonce);
        if (parameters.get("acr_values") == null) {
            parameters.put("acr_values", "2");
        }
        if (this.isInitialized()) {
            callback.onSuccess();
            return;
        }
        TelephonyManager phMgr = (TelephonyManager)this.context.getSystemService("phone");
        String networkOperator = phMgr.getNetworkOperator();
        if (TextUtils.isEmpty((CharSequence)networkOperator)) {
            callback.onError();
            return;
        }
        String mcc = networkOperator.substring(0, 3);
        String mnc = networkOperator.substring(3);
        this.getOperatorDiscoveryApi().getOperatorDiscoveryResult_ForMccMnc(this.getOperatorDiscoveryAuthHeader(), this.operatorDiscoveryConfig.getOperatorDiscoveryRedirectUri(), mcc, mnc, new Callback<OperatorDiscoveryAPI.OperatorDiscoveryResult>(){

            public void success(OperatorDiscoveryAPI.OperatorDiscoveryResult operatorDiscoveryResult, Response response) {
                MobileConnectSdkProfile.this.initAndContinue(operatorDiscoveryResult, callback);
            }

            public void failure(RetrofitError error) {
                callback.onError();
            }
        });
    }

    @Override
    public void onFinishAuthorization(boolean success) {
        super.onFinishAuthorization(success);
        if (success) {
            this.lastSeenStore.set(this.operatorDiscoveryResult);
        }
    }

    @Override
    public void validateTokens(ConnectTokensTO tokens, Date serverTimestamp) {
        super.validateTokens(tokens, serverTimestamp);
        Validator.notNull(tokens.getIdToken(), "id_token");
        Validator.notNullOrEmpty(tokens.getIdToken().getNonce(), "nonce");
        Validator.notDifferent(this.lastAuthNonce, tokens.getIdToken().getNonce(), "nonce");
    }

    private OperatorDiscoveryAPI getOperatorDiscoveryApi() {
        return RestHelper.getOperatorDiscoveryApi(this.operatorDiscoveryConfig.getOperatorDiscoveryEndpoint());
    }

    private void initAndContinue(OperatorDiscoveryAPI.OperatorDiscoveryResult odResult, SdkProfile.OnStartAuthorizationCallback callback) {
        this.operatorDiscoveryResult = odResult;
        this.setConnectIdService(this.createConnectIdService());
        this.initializeAndContinueAuthorizationFlow(callback);
    }

    private ConnectIdService createConnectIdService() {
        HttpUrl url = this.getApiUrl();
        MobileConnectAPI mobileConnectApi = RestHelper.getMobileConnectApi(String.format("%s://%s", url.scheme(), url.host()));
        return new ConnectIdService(new TokenStore(this.context), new MobileConnectAPIAdapter(mobileConnectApi), this.getClientId(), this.getRedirectUri());
    }

    @Override
    public void deInitialize() {
        super.deInitialize();
        this.setInitialized(false);
    }

    @Override
    public String getWellKnownEndpoint() {
        return this.operatorDiscoveryResult.getWellKnownEndpoint();
    }

    private String getAuthorizationHeader() {
        return "Basic " + Base64.encodeToString((byte[])String.format("%s:%s", this.getClientId(), this.getClientSecret()).getBytes(), (int)2);
    }

    private String getOperatorDiscoveryAuthHeader() {
        return Base64.encodeToString((byte[])String.format("%s:%s", this.operatorDiscoveryConfig.getOperatorDiscoveryClientId(), this.operatorDiscoveryConfig.getOperatorDiscoveryClientSecret()).getBytes(), (int)2);
    }

    private class MobileConnectAPIAdapter
    implements ConnectAPI {
        private MobileConnectAPI mobileConnectApi;

        MobileConnectAPIAdapter(MobileConnectAPI mobileConnectApi) {
            this.mobileConnectApi = mobileConnectApi;
        }

        @Override
        public void getAccessTokens(String grantType, String code, String redirectUri, String clientId, Callback<ConnectTokensTO> tokens) {
            this.mobileConnectApi.getAccessTokens(MobileConnectSdkProfile.this.getAuthorizationHeader(), MobileConnectSdkProfile.this.operatorDiscoveryResult.getPath("token"), grantType, code, redirectUri, tokens);
        }

        @Override
        public void refreshAccessTokens(String grantType, String refreshToken, String clientId, Callback<ConnectTokensTO> tokens) {
            this.mobileConnectApi.refreshAccessTokens(MobileConnectSdkProfile.this.getAuthorizationHeader(), MobileConnectSdkProfile.this.operatorDiscoveryResult.getPath("token"), grantType, refreshToken, tokens);
        }

        @Override
        public void revokeToken(String clientId, String token, ResponseCallback callback) {
            this.mobileConnectApi.revokeToken(MobileConnectSdkProfile.this.getAuthorizationHeader(), MobileConnectSdkProfile.this.operatorDiscoveryResult.getPath("tokenrevoke"), token, callback);
        }

        @Override
        public void getUserInfo(String auth, Callback<UserInfo> userInfoCallback) {
            this.mobileConnectApi.getUserInfo(auth, MobileConnectSdkProfile.this.operatorDiscoveryResult.getPath("userinfo"), userInfoCallback);
        }
    }
}

