/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.content.Context;
import android.text.TextUtils;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.SdkProfile;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.WellKnownConfigStore;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.utils.IdTokenValidator;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.Validator;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public abstract class AbstractSdkProfile
implements SdkProfile {
    private ConnectIdService connectIdService;
    private WellKnownAPI.WellKnownConfig wellKnownConfig;
    protected Context context;
    protected boolean confidentialClient;
    private volatile boolean isInitialized = false;
    private final WellKnownConfigStore lastSeenStore;

    public AbstractSdkProfile(Context context, boolean confidentialClient) {
        this.context = context;
        this.confidentialClient = confidentialClient;
        this.lastSeenStore = new WellKnownConfigStore(context);
        this.wellKnownConfig = this.lastSeenStore.get();
    }

    public abstract String getWellKnownEndpoint();

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public WellKnownAPI.WellKnownConfig getWellKnownConfig() {
        return this.wellKnownConfig;
    }

    @Override
    public boolean isConfidentialClient() {
        return this.confidentialClient;
    }

    @Override
    public ConnectIdService getConnectIdService() {
        return this.connectIdService;
    }

    @Override
    public void onFinishAuthorization(boolean success) {
        if (success) {
            this.lastSeenStore.set(this.wellKnownConfig);
        }
    }

    public void setConnectIdService(ConnectIdService connectIdService) {
        this.connectIdService = connectIdService;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    protected void deInitialize() {
        this.isInitialized = false;
        this.wellKnownConfig = null;
    }

    @Override
    public void onStartAuthorization(Map<String, String> parameters, SdkProfile.OnStartAuthorizationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)parameters.get("state"))) {
            parameters.put("state", UUID.randomUUID().toString());
        }
        if (!ConnectSdk.isCellularDataNetworkConnected()) {
            parameters.put("prompt", "no_seam");
        }
    }

    protected void initializeAndContinueAuthorizationFlow(final SdkProfile.OnStartAuthorizationCallback callback) {
        if (this.isInitialized) {
            callback.onSuccess();
            return;
        }
        RestHelper.getWellKnownApi(this.getWellKnownEndpoint()).getWellKnownConfig(new Callback<WellKnownAPI.WellKnownConfig>(){

            public void success(WellKnownAPI.WellKnownConfig config, Response response) {
                AbstractSdkProfile.this.wellKnownConfig = config;
                AbstractSdkProfile.this.isInitialized = true;
                callback.onSuccess();
            }

            public void failure(RetrofitError error) {
                AbstractSdkProfile.this.wellKnownConfig = null;
                AbstractSdkProfile.this.isInitialized = true;
                callback.onSuccess();
            }
        });
    }

    @Override
    public void validateTokens(ConnectTokensTO tokens, Date serverTimestamp) {
        Validator.notNullOrEmpty(tokens.getAccessToken(), "access_token");
        Validator.notNullOrEmpty(tokens.getTokenType(), "token_type");
        if (tokens.getIdToken() != null) {
            IdTokenValidator.validate(tokens.getIdToken(), serverTimestamp);
        }
    }
}

