/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.content.Context;
import com.google.gson.Gson;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.id.IdToken;

public class TokenStore {
    public static final String PREFERENCES_FILE = "com.telenor.connect.PREFERENCES_FILE";
    private static final String PREFERENCE_KEY_CONNECT_TOKENS = "CONNECT_TOKENS";
    private static final String PREFERENCE_KEY_ID_TOKEN = "ID_TOKEN";
    private static final Gson preferencesGson = new Gson();
    private final Context context;

    public TokenStore(Context context) {
        this.context = context;
    }

    public void set(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        String jsonIdToken = preferencesGson.toJson((Object)connectTokens.getIdToken());
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).putString(PREFERENCE_KEY_ID_TOKEN, jsonIdToken).apply();
    }

    public void update(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).apply();
    }

    public ConnectTokens get() {
        String connectTokensJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_CONNECT_TOKENS, null);
        return (ConnectTokens)preferencesGson.fromJson(connectTokensJson, ConnectTokens.class);
    }

    public void clear() {
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().clear().apply();
    }

    public IdToken getIdToken() {
        String idTokenJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_ID_TOKEN, null);
        return (IdToken)preferencesGson.fromJson(idTokenJson, IdToken.class);
    }
}

