/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import retrofit.Callback;
import retrofit.http.GET;
import retrofit.http.Headers;

public interface WellKnownAPI {
    public static final String OPENID_CONFIGURATION_PATH = "/.well-known/openid-configuration";

    @Headers(value={"Content-Type: application/json"})
    @GET(value="/")
    public void getWellKnownConfig(Callback<WellKnownConfig> var1);

    public static class WellKnownConfig
    implements Parcelable {
        @SerializedName(value="issuer")
        private String issuer;
        @SerializedName(value="network_authentication_target_ips")
        private Set<String> networkAuthenticationTargetIps;
        public static final Parcelable.Creator<WellKnownConfig> CREATOR = new Parcelable.Creator<WellKnownConfig>(){

            public WellKnownConfig createFromParcel(Parcel in) {
                return new WellKnownConfig(in);
            }

            public WellKnownConfig[] newArray(int size) {
                return new WellKnownConfig[size];
            }
        };

        public String getIssuer() {
            return this.issuer;
        }

        public Set<String> getNetworkAuthenticationTargetIps() {
            return this.networkAuthenticationTargetIps != null ? this.networkAuthenticationTargetIps : Collections.emptySet();
        }

        protected WellKnownConfig(Parcel in) {
            this.issuer = in.readString();
            int count = in.readInt();
            this.networkAuthenticationTargetIps = new HashSet<String>(count);
            for (int i = 0; i < count; ++i) {
                this.networkAuthenticationTargetIps.add(in.readString());
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.issuer);
            if (this.networkAuthenticationTargetIps == null) {
                dest.writeInt(0);
                return;
            }
            dest.writeInt(this.networkAuthenticationTargetIps.size());
            for (String ip : this.networkAuthenticationTargetIps) {
                dest.writeString(ip);
            }
        }
    }
}

