/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectNotInitializedException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.utils.IdTokenValidator;
import java.util.Date;

public class Validator {
    public static void notNull(Object var, String name) {
        if (var == null) {
            throw new NullPointerException("Variable '" + name + "' cannot be null");
        }
    }

    public static void notNullOrEmpty(String var, String name) {
        if (var == null || var.isEmpty()) {
            throw new IllegalArgumentException("Variable '" + name + "' cannot be null or empty");
        }
    }

    public static void sdkInitialized() {
        if (!ConnectSdk.isInitialized()) {
            throw new ConnectNotInitializedException("The SDK was not initialized, call ConnectSdk.sdkInitialize() first");
        }
    }

    public static void validateAuthenticationState(String state) {
        if (!Validator.validState(state)) {
            throw new ConnectException("The state parameter was changed between authentication and now.");
        }
    }

    public static boolean validState(String state) {
        return ConnectSdk.getLastAuthenticationState() == null || ConnectSdk.getLastAuthenticationState().isEmpty() || ConnectSdk.getLastAuthenticationState().equals(state);
    }

    public static void validateTokens(ConnectTokensTO tokens, Date serverTimestamp) {
        Validator.notNullOrEmpty(tokens.getAccessToken(), "access_token");
        Validator.notNull(tokens.getExpiresIn(), "expires_in");
        Validator.notNullOrEmpty(tokens.getRefreshToken(), "refresh_token");
        Validator.notNullOrEmpty(tokens.getScope(), "scope");
        Validator.notNullOrEmpty(tokens.getTokenType(), "token_type");
        if (tokens.getIdToken() != null) {
            IdTokenValidator.validate(tokens.getIdToken(), serverTimestamp);
        }
    }
}

