/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.squareup.okhttp.HttpUrl;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectException;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.TokenStore;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.ui.ConnectActivity;
import com.telenor.connect.ui.ConnectWebFragment;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import retrofit.Callback;

public final class ConnectSdk {
    private static String sClientId;
    private static boolean sConfidentialClient;
    private static Context sContext;
    private static String sLastAuthState;
    private static ArrayList<Locale> sLocales;
    private static String sPaymentCancelUri;
    private static String sPaymentSuccessUri;
    private static String sRedirectUri;
    private static boolean sSdkInitialized;
    private static boolean sUseStaging;
    private static ConnectIdService sConnectIdService;
    public static final String CLIENT_ID_PROPERTY = "com.telenor.connect.CLIENT_ID";
    public static final String CONFIDENTIAL_CLIENT_PROPERTY = "com.telenor.connect.CONFIDENTIAL_CLIENT";
    public static final String PAYMENT_CANCEL_URI_PROPERTY = "com.telenor.connect.PAYMENT_CANCEL_URI";
    public static final String PAYMENT_SUCCESS_URI_PROPERTY = "com.telenor.connect.PAYMENT_SUCCESS_URI";
    public static final String REDIRECT_URI_PROPERTY = "com.telenor.connect.REDIRECT_URI";
    public static final String USE_STAGING_PROPERTY = "com.telenor.connect.USE_STAGING";
    public static final String ACTION_LOGIN_STATE_CHANGED = "com.telenor.connect.ACTION_LOGIN_STATE_CHANGED";
    public static final String EXTRA_PAYMENT_LOCATION = "com.telenor.connect.EXTRA_PAYMENT_LOCATION";
    public static final String EXTRA_CONNECT_TOKENS = "com.telenor.connect.EXTRA_CONNECT_TOKENS";

    public static synchronized void authenticate(Activity activity, int requestCode, String ... scopeTokens) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scope", TextUtils.join((CharSequence)" ", (Object[])scopeTokens));
        ConnectSdk.authenticate(activity, parameters, requestCode);
    }

    public static synchronized void authenticate(Activity activity, Map<String, String> parameters, int requestCode) {
        Intent intent = ConnectSdk.getAuthIntent(parameters);
        activity.startActivityForResult(intent, requestCode);
    }

    private static Intent getAuthIntent(Map<String, String> parameters) {
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.setAction("com.telenor.connect.LOGIN_ACTION");
        String url = ConnectSdk.getAuthorizeUriAndSetLastAuthState(parameters).toString();
        intent.putExtra("com.telenor.connect.LOGIN_AUTH_URI", url);
        return intent;
    }

    public static synchronized void authenticate(Activity activity, Map<String, String> parameters, int customLoadingLayout, int requestCode) {
        Intent intent = ConnectSdk.getAuthIntent(parameters);
        intent.putExtra("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", customLoadingLayout);
        activity.startActivityForResult(intent, requestCode);
    }

    public static Fragment getAuthFragment(Map<String, String> parameters) {
        Validator.sdkInitialized();
        ConnectWebFragment fragment = new ConnectWebFragment();
        Intent authIntent = ConnectSdk.getAuthIntent(parameters);
        String action = authIntent.getAction();
        Bundle bundle = new Bundle(authIntent.getExtras());
        bundle.putString("com.telenor.connect.ACTION_ARGUMENT", action);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        return fragment;
    }

    public static synchronized void getValidAccessToken(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        sConnectIdService.getValidAccessToken(callback);
    }

    public static synchronized String getAccessToken() {
        Validator.sdkInitialized();
        return sConnectIdService.getAccessToken();
    }

    public static synchronized void getAccessTokenFromCode(String code, ConnectCallback callback) {
        Validator.sdkInitialized();
        sConnectIdService.getAccessTokenFromCode(code, callback);
    }

    public static synchronized Uri getAuthorizeUriAndSetLastAuthState(Map<String, String> parameters) {
        if (ConnectSdk.getClientId() == null) {
            throw new ConnectException("Client ID not specified in application manifest.");
        }
        if (ConnectSdk.getRedirectUri() == null) {
            throw new ConnectException("Redirect URI not specified in application manifest.");
        }
        if (parameters.get("scope") == null || parameters.get("scope").isEmpty()) {
            throw new IllegalStateException("Cannot log in without scope tokens.");
        }
        if (parameters.get("state") == null || parameters.get("state").isEmpty()) {
            parameters.put("state", UUID.randomUUID().toString());
        }
        sLastAuthState = parameters.get("state");
        return ConnectUrlHelper.getAuthorizeUri(parameters, ConnectSdk.getClientId(), ConnectSdk.getRedirectUri(), ConnectSdk.getUiLocales(), ConnectSdk.getConnectApiUrl());
    }

    public static HttpUrl getConnectApiUrl() {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        builder.scheme("https");
        builder.host(sUseStaging ? "connect.staging.telenordigital.com" : "connect.telenordigital.com");
        return builder.build();
    }

    public static Context getContext() {
        Validator.sdkInitialized();
        return sContext;
    }

    public static String getClientId() {
        Validator.sdkInitialized();
        return sClientId;
    }

    public static String getLastAuthenticationState() {
        Validator.sdkInitialized();
        return sLastAuthState;
    }

    public static ArrayList<Locale> getLocales() {
        Validator.sdkInitialized();
        return sLocales;
    }

    public static String getPaymentCancelUri() {
        Validator.sdkInitialized();
        return sPaymentCancelUri;
    }

    public static String getPaymentSuccessUri() {
        Validator.sdkInitialized();
        return sPaymentSuccessUri;
    }

    public static String getRedirectUri() {
        Validator.sdkInitialized();
        return sRedirectUri;
    }

    private static ArrayList<String> getUiLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        if (ConnectSdk.getLocales() != null && !ConnectSdk.getLocales().isEmpty()) {
            for (Locale locale : ConnectSdk.getLocales()) {
                locales.add(locale.toString());
                locales.add(locale.getLanguage());
            }
        }
        locales.add(Locale.getDefault().toString());
        locales.add(Locale.getDefault().getLanguage());
        return locales;
    }

    public static void initializePayment(Context context, String transactionLocation) {
        Validator.sdkInitialized();
        if (ConnectSdk.getPaymentSuccessUri() == null || ConnectSdk.getPaymentCancelUri() == null) {
            throw new ConnectException("Payment success or cancel URI not specified in applicationmanifest.");
        }
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.putExtra(EXTRA_PAYMENT_LOCATION, transactionLocation);
        intent.setAction("com.telenor.connect.PAYMENT_ACTION");
        Activity activity = (Activity)context;
        activity.startActivityForResult(intent, 1);
    }

    public static synchronized boolean isConfidentialClient() {
        return sConfidentialClient;
    }

    public static synchronized boolean isInitialized() {
        return sSdkInitialized;
    }

    public static void logout() {
        Validator.sdkInitialized();
        sConnectIdService.revokeTokens(sContext);
    }

    public static synchronized void sdkInitialize(Context context) {
        if (sSdkInitialized) {
            return;
        }
        Validator.notNull(context, "context");
        sContext = context;
        ConnectSdk.loadConnectConfig(sContext);
        sSdkInitialized = true;
        sConnectIdService = new ConnectIdService(new TokenStore(context), RestHelper.getConnectApi(ConnectSdk.getConnectApiUrl().toString()), sClientId, sRedirectUri);
    }

    public static void setLocales(Locale ... locales) {
        sLocales = new ArrayList<Locale>(Arrays.asList(locales));
    }

    public static void setLocales(ArrayList<Locale> locales) {
        sLocales = locales;
    }

    public static void updateTokens(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        sConnectIdService.updateTokens(callback);
    }

    private static void loadConnectConfig(Context context) {
        Object paymentSuccessUriObject;
        Object paymentCancelUriObject;
        Object useStagingObject;
        Object redirectUriObject;
        Object confidentialClientObject;
        if (context == null) {
            return;
        }
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            throw new ConnectException("No application metadata was found.");
        }
        Object clientIdObject = ai.metaData.get(CLIENT_ID_PROPERTY);
        if (clientIdObject instanceof String) {
            String clientIdString;
            sClientId = clientIdString = (String)clientIdObject;
        }
        if ((confidentialClientObject = ai.metaData.get(CONFIDENTIAL_CLIENT_PROPERTY)) instanceof Boolean) {
            sConfidentialClient = (Boolean)confidentialClientObject;
        }
        if ((redirectUriObject = ai.metaData.get(REDIRECT_URI_PROPERTY)) instanceof String) {
            String redirectUriString;
            sRedirectUri = redirectUriString = (String)redirectUriObject;
        }
        if ((useStagingObject = ai.metaData.get(USE_STAGING_PROPERTY)) instanceof Boolean) {
            sUseStaging = (Boolean)useStagingObject;
        }
        if ((paymentCancelUriObject = ai.metaData.get(PAYMENT_CANCEL_URI_PROPERTY)) instanceof String) {
            String paymentCancelUriString;
            sPaymentCancelUri = paymentCancelUriString = (String)paymentCancelUriObject;
        }
        if ((paymentSuccessUriObject = ai.metaData.get(PAYMENT_SUCCESS_URI_PROPERTY)) instanceof String) {
            String paymentSuccessUriString;
            sPaymentSuccessUri = paymentSuccessUriString = (String)paymentSuccessUriObject;
        }
    }

    @Deprecated
    public static String getSubjectId() {
        Validator.sdkInitialized();
        IdToken idToken = sConnectIdService.getIdToken();
        return idToken != null ? idToken.getSubject() : null;
    }

    public static IdToken getIdToken() {
        Validator.sdkInitialized();
        return sConnectIdService.getIdToken();
    }

    public static void getUserInfo(Callback<UserInfo> userInfoCallback) {
        Validator.sdkInitialized();
        sConnectIdService.getUserInfo(userInfoCallback);
    }

    static {
        sConfidentialClient = false;
        sSdkInitialized = false;
        sUseStaging = false;
    }
}

