/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.sms;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import com.telenor.connect.sms.SmsHandler;

public class SmsBroadcastReceiver
extends BroadcastReceiver {
    private final SmsHandler smsHandler;

    public SmsBroadcastReceiver(SmsHandler smsHandler) {
        this.smsHandler = smsHandler;
    }

    public void onReceive(Context context, Intent intent) {
        if (!intent.getAction().equals("android.provider.Telephony.SMS_RECEIVED")) {
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        SmsMessage[] messages = SmsBroadcastReceiver.getSmsMessages(intent, bundle);
        String messageBody = SmsBroadcastReceiver.getMessageBodies(messages);
        String originatingAddress = messages[0].getOriginatingAddress();
        this.smsHandler.receivedSms(originatingAddress, messageBody);
    }

    private static SmsMessage[] getSmsMessages(Intent intent, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Telephony.Sms.Intents.getMessagesFromIntent((Intent)intent);
        }
        return SmsBroadcastReceiver.getSmsMessages(bundle);
    }

    private static SmsMessage[] getSmsMessages(Bundle bundle) {
        Object[] pdus = (Object[])bundle.get("pdus");
        SmsMessage[] messages = new SmsMessage[pdus.length];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
        }
        return messages;
    }

    private static String getMessageBodies(SmsMessage[] messages) {
        StringBuilder stringBuilder = new StringBuilder();
        for (SmsMessage message : messages) {
            stringBuilder.append(message.getMessageBody());
        }
        return stringBuilder.toString();
    }
}

