/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.id.ActivityFinisherConnectCallback;
import com.telenor.connect.utils.Validator;
import java.util.Map;

public class ParseTokenCallback
implements ConnectCallback {
    private final Activity activity;

    public ParseTokenCallback(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void onSuccess(Object successData) {
        Validator.notNullOrEmpty(successData.toString(), "auth reponse");
        Map authCodeData = (Map)successData;
        if (ConnectSdk.isConfidentialClient()) {
            Intent intent = new Intent();
            for (Map.Entry entry : authCodeData.entrySet()) {
                intent.putExtra((String)entry.getKey(), (String)entry.getValue());
            }
            this.activity.setResult(-1, intent);
            this.activity.finish();
        } else {
            ConnectSdk.getAccessTokenFromCode((String)authCodeData.get("code"), new ActivityFinisherConnectCallback(this.activity));
        }
    }

    @Override
    public void onError(Object errorData) {
        Log.e((String)"ConnectSDK", (String)errorData.toString());
        Intent intent = new Intent();
        Map authCodeData = (Map)errorData;
        for (Map.Entry entry : authCodeData.entrySet()) {
            intent.putExtra((String)entry.getKey(), (String)entry.getValue());
        }
        this.activity.setResult(0, intent);
        this.activity.finish();
    }
}

