/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectNotSignedInException;
import com.telenor.connect.ConnectRefreshTokenMissingException;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.id.ConnectTokensTO;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.TokenStore;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.utils.ConnectUtils;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class ConnectIdService {
    private final ConnectAPI connectApi;
    private final TokenStore tokenStore;
    private final String redirectUrl;
    private final String clientId;
    private ConnectTokens currentTokens;
    private IdToken idToken;

    public ConnectIdService(TokenStore tokenStore, ConnectAPI connectApi, String clientId, String redirectUrl) {
        this.clientId = clientId;
        this.redirectUrl = redirectUrl;
        this.connectApi = connectApi;
        this.tokenStore = tokenStore;
    }

    public void getValidAccessToken(AccessTokenCallback callback) {
        if (this.retrieveTokens() == null) {
            throw new ConnectRefreshTokenMissingException("retrieveTokens() returned null. Tokens are missing.");
        }
        if (this.retrieveTokens().accessTokenHasExpired()) {
            this.updateTokens(callback);
            return;
        }
        callback.onSuccess(this.retrieveTokens().getAccessToken());
    }

    public String getAccessToken() {
        if (this.retrieveTokens() == null) {
            return null;
        }
        return this.retrieveTokens().getAccessToken();
    }

    public void getAccessTokenFromCode(String authCode, final ConnectCallback callback) {
        this.connectApi.getAccessTokens("authorization_code", authCode, this.redirectUrl, this.clientId, new Callback<ConnectTokensTO>(){

            public void success(ConnectTokensTO connectTokensTO, Response response) {
                ConnectTokens connectTokens = new ConnectTokens(connectTokensTO);
                ConnectIdService.this.tokenStore.set(connectTokens);
                ConnectIdService.this.currentTokens = connectTokens;
                ConnectIdService.this.idToken = connectTokens.getIdToken();
                ConnectUtils.sendTokenStateChanged(true);
                if (callback != null) {
                    callback.onSuccess(connectTokens);
                }
            }

            public void failure(RetrofitError error) {
                ConnectUtils.sendTokenStateChanged(false);
                if (callback != null) {
                    callback.onError(error.toString());
                }
            }
        });
    }

    private String getRefreshToken() {
        if (this.retrieveTokens() == null) {
            return null;
        }
        return this.retrieveTokens().getRefreshToken();
    }

    public void revokeTokens(Context context) {
        this.connectApi.revokeToken(this.clientId, this.getAccessToken(), new ResponseCallback(){

            public void success(Response response) {
            }

            public void failure(RetrofitError error) {
                Log.e((String)"ConnectSDK", (String)"Failed to call revoke access token on API", (Throwable)error);
            }
        });
        this.connectApi.revokeToken(this.clientId, this.getRefreshToken(), new ResponseCallback(){

            public void success(Response response) {
            }

            public void failure(RetrofitError error) {
                Log.e((String)"ConnectSDK", (String)"Failed to call revoke refresh token on API", (Throwable)error);
            }
        });
        this.tokenStore.clear();
        this.currentTokens = null;
        this.idToken = null;
        ConnectUtils.sendTokenStateChanged(false);
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
        } else {
            CookieSyncManager.createInstance((Context)context);
            cookieManager.removeAllCookie();
        }
    }

    public void updateTokens(final AccessTokenCallback callback) {
        String refreshToken = this.getRefreshToken();
        if (refreshToken == null) {
            throw new ConnectRefreshTokenMissingException("Refresh token missing, can't update tokens.");
        }
        this.connectApi.refreshAccessTokens("refresh_token", refreshToken, this.clientId, new Callback<ConnectTokensTO>(){

            public void success(ConnectTokensTO connectTokensTO, Response response) {
                ConnectTokens connectTokens = new ConnectTokens(connectTokensTO);
                ConnectIdService.this.tokenStore.update(connectTokens);
                ConnectIdService.this.currentTokens = connectTokens;
                callback.onSuccess(connectTokens.getAccessToken());
            }

            public void failure(RetrofitError error) {
                if (error != null && error.getResponse() != null && error.getResponse().getStatus() >= 400 && error.getResponse().getStatus() < 500) {
                    ConnectIdService.this.tokenStore.clear();
                    ConnectIdService.this.currentTokens = null;
                }
                callback.onError(error);
            }
        });
    }

    private ConnectTokens retrieveTokens() {
        if (this.currentTokens == null) {
            this.currentTokens = this.tokenStore.get();
        }
        return this.currentTokens;
    }

    public IdToken getIdToken() {
        if (this.idToken == null) {
            this.idToken = this.tokenStore.getIdToken();
        }
        return this.idToken;
    }

    public void getUserInfo(Callback<UserInfo> userInfoCallback) throws ConnectNotSignedInException {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            throw new ConnectNotSignedInException("No user is signed in. accessToken=" + accessToken);
        }
        String auth = "Bearer " + accessToken;
        this.connectApi.getUserInfo(auth, userInfoCallback);
    }
}

