/*
 * Decompiled with CFR 0.152.
 */
package com.telen.library.advanced_gps.services;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.telen.library.IFollomiGPS;
import com.telen.library.IFollomiGPSListener;
import com.telen.library.advanced_gps.GoogleFusedInstance;
import com.telen.library.advanced_gps.R;

public abstract class AdvancedGPSService
extends Service {
    private static final String TAG = "AdvancedGPSService";
    private final FollomiLocationManager iGPS = new FollomiLocationManager();
    private IFollomiGPSListener iListener;
    private LocationCallback mLocationCallback = new LocationCallback(){

        public void onLocationResult(LocationResult locationResult) {
            if (locationResult == null) {
                return;
            }
            for (Location location : locationResult.getLocations()) {
                AdvancedGPSService.this.onNewPosition(location);
                if (AdvancedGPSService.this.iListener == null) continue;
                try {
                    AdvancedGPSService.this.iListener.onLocationChanged(location);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)AdvancedGPSService.TAG, (String)"", (Throwable)e);
                }
            }
        }
    };

    protected abstract void onNewPosition(@Nullable Location var1);

    protected abstract void onLocationStarted();

    protected abstract void onLocationStopped();

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)TAG, (String)"onStartCommand");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel channel = this.getNotificationChannel();
            notificationManager.createNotificationChannel(channel);
            Notification notification = new NotificationCompat.Builder((Context)this, channel.getId()).setSmallIcon(R.drawable.ic_location_on_black_24dp).build();
            this.startForeground(startId, notification);
        }
        return 3;
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)TAG, (String)"onUnbind");
        this.iListener = null;
        return super.onUnbind(intent);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.iGPS;
    }

    private void stopLocationUpdates() {
        GoogleFusedInstance.getInstance((Context)this).getFusedLocationProviderClient().removeLocationUpdates(this.mLocationCallback).addOnSuccessListener(aVoid -> {
            this.onLocationStopped();
            if (this.iListener != null) {
                try {
                    this.iListener.onLocationSuccessfullyStopped();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
            }
        }).addOnFailureListener(e -> Log.e((String)TAG, (String)"", (Throwable)e));
    }

    @SuppressLint(value={"MissingPermission"})
    private void startLocationsUpdates(int powerPlan) {
        Log.d((String)TAG, (String)"startLocationUpdates");
        LocationRequest locationRequest = this.createLocationRequest(powerPlan);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        LocationServices.getSettingsClient((Context)this).checkLocationSettings(builder.build()).addOnSuccessListener(locationSettingsResponse -> {
            if (!this.checkPermissions(2)) {
                return;
            }
            GoogleFusedInstance.getInstance((Context)this).getFusedLocationProviderClient().requestLocationUpdates(locationRequest, this.mLocationCallback, null).addOnSuccessListener(aVoid -> {
                this.onLocationStarted();
                if (this.iListener != null) {
                    try {
                        this.iListener.onLocationSuccessfullyStarted();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        Log.e((String)TAG, (String)"", (Throwable)e);
                    }
                }
            }).addOnFailureListener(e -> Log.e((String)TAG, (String)"", (Throwable)e));
        }).addOnFailureListener(e -> {
            if (e instanceof ResolvableApiException) {
                ResolvableApiException resolvable = (ResolvableApiException)e;
                if (this.iListener != null) {
                    try {
                        this.iListener.onLocationTurnedOff(2, resolvable.getResolution());
                    }
                    catch (RemoteException e1) {
                        e1.printStackTrace();
                        Log.e((String)TAG, (String)"", (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean checkPermissions(int code) {
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            if (this.iListener != null) {
                try {
                    this.iListener.onNeedLocationPermissions(code);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    private LocationRequest createLocationRequest(int powerPlan) {
        LocationRequest mLocationRequest = LocationRequest.create();
        mLocationRequest.setPriority(powerPlan);
        switch (powerPlan) {
            case 102: {
                mLocationRequest.setFastestInterval(60000L);
                mLocationRequest.setInterval(3600000L);
                break;
            }
            case 100: {
                mLocationRequest.setInterval(5000L);
                mLocationRequest.setFastestInterval(3000L);
                break;
            }
            case 104: {
                mLocationRequest.setFastestInterval(60000L);
                mLocationRequest.setInterval(3600000L);
                break;
            }
        }
        Log.d((String)TAG, (String)("powerPlan=" + powerPlan));
        return mLocationRequest;
    }

    @SuppressLint(value={"MissingPermission"})
    private void getLastKnownLocationInternal() {
        if (!this.checkPermissions(0)) {
            return;
        }
        GoogleFusedInstance.getInstance((Context)this).getFusedLocationProviderClient().getLastLocation().addOnSuccessListener(location -> {
            if (this.iListener != null) {
                try {
                    this.iListener.onLastKnownLocation((Location)location);
                }
                catch (RemoteException e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }).addOnFailureListener(e -> {
            if (this.iListener != null) {
                try {
                    this.iListener.onLastKnownLocationFailed(e.getMessage());
                }
                catch (RemoteException error) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                    error.printStackTrace();
                }
            }
        });
    }

    @TargetApi(value=26)
    protected NotificationChannel getNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = this.getString(R.string.gps_notification_channel_id);
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"Locations listener", 3);
            return channel;
        }
        return null;
    }

    public class FollomiLocationManager
    extends IFollomiGPS.Stub {
        @Override
        public void startLocationListener(int powerPlan) throws RemoteException {
            Log.d((String)AdvancedGPSService.TAG, (String)("startLocationListener powerPlan=" + powerPlan));
            AdvancedGPSService.this.startLocationsUpdates(powerPlan);
        }

        @Override
        public void stopLocationListener() throws RemoteException {
            Log.d((String)AdvancedGPSService.TAG, (String)"startLocationListener");
            AdvancedGPSService.this.stopLocationUpdates();
        }

        @Override
        public void getLastKnownLocation() throws RemoteException, SecurityException {
            Log.d((String)AdvancedGPSService.TAG, (String)"getLastKnowLocation");
            AdvancedGPSService.this.getLastKnownLocationInternal();
        }

        @Override
        public void registerListener(IFollomiGPSListener listener) throws RemoteException {
            Log.d((String)AdvancedGPSService.TAG, (String)"registerListener");
            AdvancedGPSService.this.iListener = listener;
        }

        @Override
        public void unregisterListener() throws RemoteException {
            Log.d((String)AdvancedGPSService.TAG, (String)"unregisterListener");
            AdvancedGPSService.this.iListener = null;
        }
    }
}

