/*
 * Decompiled with CFR 0.152.
 */
package com.telen.library.advanced_gps.manager;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.location.Location;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.util.Log;
import com.telen.library.IFollomiGPS;
import com.telen.library.IFollomiGPSListener;
import com.telen.library.advanced_gps.R;
import com.telen.library.advanced_gps.models.GPSCallback;
import com.telen.library.advanced_gps.models.QueueModel;
import java.util.ArrayList;
import java.util.List;

public class GPSManager {
    private static final boolean DEBUG = true;
    private static final String TAG = GPSManager.class.getName();
    static final Object callbacksLock = new Object();
    private final Context context;
    private ConnectionManager iCManager = new ConnectionManager();
    private ArrayList<GPSCallback> callbacks = new ArrayList();
    private ArrayList<QueueModel.QUEUE_ACTION> waitingQueue = new ArrayList();
    private IFollomiGPS igps;
    private final Intent intent;

    public GPSManager(Context context) throws IllegalStateException {
        this.context = context;
        Log.d((String)TAG, (String)"GPSManager()");
        Intent queryIntent = new Intent("com.telen.action.EXTRA_GPS_SERVICE");
        PackageManager packageManager = context.getPackageManager();
        List services = packageManager.queryIntentServices(queryIntent, 128);
        if (services != null) {
            for (ResolveInfo resolveInfo : services) {
                Log.d((String)TAG, (String)("service=" + resolveInfo));
                ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                if (serviceInfo == null) continue;
                ComponentName cn = new ComponentName(serviceInfo.packageName, serviceInfo.name);
                this.intent = new Intent("com.telen.action.EXTRA_GPS_SERVICE");
                this.intent.setComponent(cn);
                this.context.bindService(this.intent, (ServiceConnection)this.iCManager, 1);
                return;
            }
        }
        throw new IllegalArgumentException("No gps service found in the manifest.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = callbacksLock;
        synchronized (object) {
            this.callbacks.clear();
        }
        this.waitingQueue.clear();
        try {
            this.context.unbindService((ServiceConnection)this.iCManager);
            this.igps = null;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    public void startLocationListener() {
        if (this.igps != null) {
            Log.d((String)TAG, (String)"launchLocationListener");
            try {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
                int gps_accuracy = Integer.parseInt(prefs.getString(this.context.getString(R.string.key_gps_accuracy), this.context.getString(R.string.default_gps_sync)));
                this.igps.startLocationListener(gps_accuracy);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
        } else {
            this.waitingQueue.add(QueueModel.QUEUE_ACTION.LAUNCH_LOCATION_LISTENER);
        }
    }

    public void stopLocationListener() {
        if (this.igps != null) {
            Log.d((String)TAG, (String)"stopLocationListener");
            try {
                this.igps.stopLocationListener();
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
        } else {
            this.waitingQueue.add(QueueModel.QUEUE_ACTION.STOP_LOCATION_LISTENER);
        }
    }

    public void getLastKnownLocation() {
        Log.d((String)TAG, (String)"getLastKnowLocation");
        if (this.igps != null) {
            try {
                this.igps.getLastKnownLocation();
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
        } else {
            this.waitingQueue.add(QueueModel.QUEUE_ACTION.LAST_KNOW_LOCATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(GPSCallback callback) {
        Object object = callbacksLock;
        synchronized (object) {
            this.callbacks.add(callback);
        }
        Log.d((String)TAG, (String)("addCallback: New size=" + this.callbacks.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCallback(GPSCallback callback) {
        Object object = callbacksLock;
        synchronized (object) {
            if (this.callbacks != null) {
                int size = this.callbacks.size();
                for (int i = size - 1; i >= 0; --i) {
                    this.callbacks.remove(callback);
                }
                Log.d((String)TAG, (String)("deleteCallback: New size=" + this.callbacks.size()));
            }
        }
    }

    public boolean isBound() {
        return this.igps != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindService() {
        if (this.iCManager != null) {
            try {
                this.context.unbindService((ServiceConnection)this.iCManager);
                this.igps = null;
                Object object = callbacksLock;
                synchronized (object) {
                    for (GPSCallback callback : this.callbacks) {
                        callback.onDisconnected();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
        }
    }

    public void bindService() {
        if (this.intent != null) {
            boolean bound = this.context.bindService(this.intent, (ServiceConnection)this.iCManager, 1);
            Log.d((String)TAG, (String)("bindService: bound=" + bound));
        }
    }

    private class ConnectionManager
    extends IFollomiGPSListener.Stub
    implements ServiceConnection {
        private ConnectionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d((String)TAG, (String)"onServiceConnected");
            GPSManager.this.igps = IFollomiGPS.Stub.asInterface(service);
            try {
                GPSManager.this.igps.registerListener(GPSManager.this.iCManager);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
            for (QueueModel.QUEUE_ACTION action : GPSManager.this.waitingQueue) {
                switch (action) {
                    case LAUNCH_LOCATION_LISTENER: {
                        GPSManager.this.startLocationListener();
                        break;
                    }
                    case STOP_LOCATION_LISTENER: {
                        GPSManager.this.stopLocationListener();
                        break;
                    }
                    case LAST_KNOW_LOCATION: {
                        GPSManager.this.getLastKnownLocation();
                    }
                }
            }
            GPSManager.this.waitingQueue.clear();
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onConnected();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)TAG, (String)"onServiceDisconnected");
            GPSManager.this.igps = null;
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onDisconnected();
                }
            }
        }

        public void onBindingDied(ComponentName name) {
            Log.d((String)TAG, (String)"onBindingDied");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) throws RemoteException {
            Log.d((String)TAG, (String)("GPSManager: onLocationChanged from listener callback.size=" + GPSManager.this.callbacks.size()));
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLocationChangeListener(location);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLastKnownLocation(Location location) throws RemoteException {
            Log.d((String)TAG, (String)"GPSManager: onLastKnowLocation from listener");
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLastKnownLocation(location);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLastKnownLocationFailed(String exception) throws RemoteException {
            Log.d((String)TAG, (String)("GPSManager: onLastKnownLocationFailed from listener e=" + exception));
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLastKnownLocationFailed(exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNeedLocationPermissions(int code) throws RemoteException {
            Log.e((String)TAG, (String)"GPSManager: onNeedLocationPermissions");
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onNeedLocationPermissions(code);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationTurnedOff(int code, PendingIntent resolvingIntent) throws RemoteException {
            Log.e((String)TAG, (String)"GPSManager: onLocationTurnedOff");
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLocationTurnedOff(code, resolvingIntent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationSuccessfullyStarted() throws RemoteException {
            Log.d((String)TAG, (String)"GPSManager: onLocationSuccessfullyStarted");
            if (Build.VERSION.SDK_INT >= 26) {
                GPSManager.this.context.startForegroundService(GPSManager.this.intent);
            } else {
                GPSManager.this.context.startService(GPSManager.this.intent);
            }
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLocationSuccessfullyStarted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationSuccessfullyStopped() throws RemoteException {
            GPSManager.this.context.stopService(GPSManager.this.intent);
            Log.d((String)TAG, (String)"GPSManager: onLocationSuccessfullyStopped");
            Object object = callbacksLock;
            synchronized (object) {
                for (GPSCallback callback : GPSManager.this.callbacks) {
                    callback.onLocationSuccessfullyStopped();
                }
            }
        }
    }
}

