/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.process;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.process.Executor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmdLineExecutor
implements Executor {
    ProcessBuilder builder;
    Process currentProcess;
    List<String> args = new ArrayList<String>();
    BufferedWriter writer;
    BufferedReader reader;
    private static final Logger logger = Logger.getLogger(CmdLineExecutor.class);

    public CmdLineExecutor(Map<String, String> environment) {
        this.builder = new ProcessBuilder(this.args);
        Map<String, String> env = this.builder.environment();
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
    }

    public CmdLineExecutor(Map<String, String> environment, File runningDirectory) {
        this(environment);
        if (this.builder != null) {
            this.builder.directory(runningDirectory);
        }
    }

    @Override
    public void exec(String exe, String[] args) throws PerforceException {
        this.args.clear();
        if ("p4".equals(args[0]) && exe != null) {
            args[0] = exe;
        }
        this.args.addAll(Arrays.asList(args));
        if (logger.isDebugEnabled()) {
            StringBuilder debug = new StringBuilder();
            for (String arg : args) {
                debug.append(arg).append(" ");
            }
            if (debug.toString().contains(" login ")) {
                logger.debug((Object)"Attempting to login to Perforce...");
            } else {
                logger.debug((Object)("Executing: " + debug));
            }
            if (this.builder.directory() != null) {
                logger.debug((Object)("In directory: " + this.builder.directory()));
            } else {
                logger.debug((Object)("In directory: " + new File("").getAbsolutePath()));
            }
        }
        this.builder.redirectErrorStream(true);
        try {
            this.currentProcess = this.builder.start();
            this.reader = new BufferedReader(new InputStreamReader(this.currentProcess.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.currentProcess.getOutputStream()));
        }
        catch (IOException e) {
            throw new PerforceException("Failed to open connection to: " + args[0], e);
        }
    }

    @Override
    public BufferedReader getReader() {
        return this.reader;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Process getProcess() {
        return this.currentProcess;
    }
}

