/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.EventLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Debug {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTICE = 3;
    public static final int VERBOSE = 99;
    public static final int LOG_NONE = 0;
    public static final int LOG_SPLIT = 1;
    public static final int LOG_ONLY = 3;
    private static int level = 0;
    private static EventLog elog = null;
    private static int log_level = 3;
    private static boolean show_thread = false;
    private static final Logger logger = Logger.getLogger(Debug.class);

    public static String getLevelName(int level) {
        if (0 >= level) {
            return "NONE";
        }
        if (1 >= level) {
            return "ERROR";
        }
        if (2 >= level) {
            return "WARNING";
        }
        if (3 >= level) {
            return "NOTICE";
        }
        return "VERBOSE";
    }

    public static void setDebugLevel(int l) {
        level = l;
    }

    public static int getDebugLevel() {
        return level;
    }

    public static void setShowThread(boolean show) {
        show_thread = show;
    }

    public static boolean getShowThread() {
        return show_thread;
    }

    public static void setEventLog(EventLog elog) {
        Debug.elog = elog;
    }

    public static EventLog getEventLog() {
        return elog;
    }

    public static void setLogLevel(String level) {
        if (level.equalsIgnoreCase("split")) {
            Debug.setLogLevel(1);
        } else if (level.equalsIgnoreCase("only")) {
            Debug.setLogLevel(3);
        } else {
            Debug.setLogLevel(0);
        }
    }

    public static void setProperties(Properties props) {
        String log = props.getProperty("p4.log_level", "none");
        log_level = log.equalsIgnoreCase("split") ? 1 : (log.equalsIgnoreCase("only") ? 3 : 0);
    }

    public static void setLogLevel(int log_level) {
        Debug.log_level = log_level;
        if (0 == Debug.log_level) {
            level = 0;
        }
    }

    public static int getLogLevel() {
        return log_level;
    }

    private static void errLog(String msg, String level) {
        logger.log(Priority.toPriority((String)level), (Object)msg);
        if (null == elog) {
            return;
        }
        elog.log(Debug.getThreadName() + msg, level);
    }

    private static String getThreadName() {
        return show_thread ? Thread.currentThread().getName() + ": " : "";
    }

    public static void error(String msg) {
        logger.error((Object)msg);
        if (1 > level) {
            return;
        }
        System.out.println(Debug.getThreadName() + "ERROR: " + msg);
        System.out.flush();
        if (1 <= log_level) {
            Debug.errLog(msg, "ERROR");
        }
    }

    public static void warn(String msg) {
        logger.warn((Object)msg);
        if (2 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + "WARNING: " + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg, "WARNING");
        }
    }

    public static void notify(String msg) {
        logger.info((Object)msg);
        if (3 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg, "NOTIFY");
        }
    }

    public static void notify(String msg, String[] arry) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        logger.info((Object)(msg + sb));
        if (3 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg + sb, "NOTIFY");
        }
    }

    public static void verbose(String msg) {
        logger.debug((Object)msg);
        if (99 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg, "VERBOSE");
        }
    }

    public static void verbose(String msg, String[] arry) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        logger.debug((Object)(msg + sb));
        if (99 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg + sb, "VERBOSE");
        }
    }

    public static void out(int level, Throwable t) {
        Debug.out("{0}", level, t);
    }

    public static void out(String format, int level, Throwable t) {
        if (level > Debug.level) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            Object[] args = new Object[]{sw.toString()};
            String msg = MessageFormat.format(format, args);
            if (1 >= log_level) {
                System.out.println(Debug.getThreadName() + msg);
                System.out.flush();
            }
            if (1 <= log_level) {
                Debug.errLog(msg, Debug.getLevelName(level));
            }
        }
        catch (Exception ex) {
            System.err.println(t);
            System.err.flush();
        }
    }

    public static void out(int level, String msg) {
        if (level > Debug.level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg, Debug.getLevelName(level));
        }
    }

    public static void out(int level, String msg, String[] arry) {
        if (level > Debug.level) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog(msg + sb, Debug.getLevelName(level));
        }
    }
}

