/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public abstract class ContextMenu {
    protected abstract void init(Menu var1, ShowContextMenuCallback.Action var2);

    public void show(Composite composite, Point location, ShowContextMenuCallback.Action callback) {
        SafeExecutor.asyncExec((Widget)composite, () -> {
            Menu menu = new Menu((Control)composite);
            menu.addListener(12, event -> {
                if (!callback.isClosed()) {
                    callback.close();
                }
            });
            menu.addMenuListener((MenuListener)new MyPopupMenuListener(menu, callback));
            this.init(menu, callback);
            menu.setLocation(composite.toDisplay(location.x(), location.y()));
            menu.setVisible(true);
        });
    }

    private static class MyPopupMenuListener
    implements MenuListener {
        private final Menu menu;
        private final ShowContextMenuCallback.Action callback;

        private MyPopupMenuListener(Menu menu, ShowContextMenuCallback.Action callback) {
            this.menu = menu;
            this.callback = callback;
        }

        public void menuHidden(MenuEvent menuEvent) {
            this.menu.getDisplay().asyncExec(() -> {
                if (!this.callback.isClosed()) {
                    this.callback.close();
                }
                this.menu.dispose();
            });
        }

        public void menuShown(MenuEvent menuEvent) {
        }
    }
}

