/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dialog;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.dialog.CustomDialog;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class PromptDialog
extends CustomDialog {
    private Text inputField;
    private String enteredText;

    public static Builder newBuilder(Shell parent, String message) {
        return new Builder(parent, message);
    }

    private PromptDialog(Builder builder) {
        super(builder);
        this.enteredText = builder.initialText;
    }

    @Override
    protected Composite createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        RowLayout layout = new RowLayout(512);
        layout.pack = false;
        result.setLayout((Layout)layout);
        this.putDisplayedMessage(result);
        this.inputField = new Text(result, 2048);
        this.inputField.addModifyListener(e -> {
            this.enteredText = this.inputField.getText();
        });
        this.inputField.setText(this.enteredText);
        return result;
    }

    public String enteredText() {
        return this.enteredText;
    }

    public static final class Builder
    extends CustomDialog.Builder<PromptDialog, Builder> {
        private String initialText;

        private Builder(Shell parent, String message) {
            super(parent, message);
        }

        public Builder initialText(String initialText) {
            this.initialText = (String)Preconditions.checkNotNull((Object)initialText);
            return this.self();
        }

        @Override
        public PromptDialog build() {
            Preconditions.checkNotNull((Object)this.initialText, (Object)"The initial text is required for the prompt dialog.");
            return new PromptDialog(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

