/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.swt.internal.DpiAwareRectangle;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import org.eclipse.swt.graphics.Point;

final class WindowedWidgetBounds {
    private final Rect inScreen;
    private final Rect inWindow;

    private WindowedWidgetBounds(Rect inScreen, Rect inWindow) {
        this.inWindow = inWindow;
        this.inScreen = inScreen;
    }

    static WindowedWidgetBounds calculateFor(WindowedWidget widget, Display primaryDisplay) {
        DpiAwareRectangle widgetBounds = new DpiAwareRectangle(widget.getBounds(), widget.getDisplay(), primaryDisplay.scaleFactor());
        Rect locationInShell = Rect.of((int)widgetBounds.x(), (int)widgetBounds.y(), (int)widgetBounds.width(), (int)widgetBounds.height());
        Point locationOnScreen = widget.toDisplay(1, 1);
        Rect boundsInScreen = Rect.of((int)locationOnScreen.x, (int)locationOnScreen.y, (int)widgetBounds.width(), (int)widgetBounds.height());
        return new WindowedWidgetBounds(boundsInScreen, locationInShell);
    }

    Rect inScreen() {
        return this.inScreen;
    }

    Rect inWindow() {
        return this.inWindow;
    }
}

