/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

final class TabbingAssistant {
    private final BrowserView browserView;

    TabbingAssistant(BrowserView browserView) {
        this.browserView = (BrowserView)((Object)Preconditions.checkNotNull((Object)((Object)browserView)));
    }

    void passFocusToNext() {
        Optional<Composite> parent = TabbingAssistant.nonDisposedParent(this.browserView);
        parent.ifPresent(parentComposite -> {
            List<Control> siblings = TabbingAssistant.children(parentComposite);
            int compositeIndex = siblings.indexOf((Object)this.browserView);
            if (compositeIndex == siblings.size() - 1) {
                siblings.get(0).setFocus();
            } else {
                siblings.get(compositeIndex + 1).setFocus();
            }
        });
    }

    void passFocusToPrev() {
        Optional<Composite> parent = TabbingAssistant.nonDisposedParent(this.browserView);
        parent.ifPresent(parentComposite -> {
            List<Control> siblings = TabbingAssistant.children(parentComposite);
            int siblingIndex = siblings.indexOf((Object)this.browserView);
            if (siblingIndex == 0) {
                siblings.get(siblings.size() - 1).setFocus();
            } else {
                siblings.get(siblingIndex - 1).setFocus();
            }
        });
    }

    private static Optional<Composite> nonDisposedParent(Composite composite) {
        if (composite.isDisposed()) {
            return Optional.empty();
        }
        Composite parent = composite.getParent();
        if (parent == null || parent.isDisposed()) {
            return Optional.empty();
        }
        return Optional.of(parent);
    }

    private static List<Control> children(Composite parent) {
        return Arrays.stream(parent.getChildren()).collect(Collectors.toList());
    }
}

