/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.WebDialogCreated;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.GraphicsWebDialogView;
import com.teamdev.jxbrowser.view.swt.internal.MemoryImage;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Widget;

final class GraphicsRenderWidget
extends OffScreenRenderWidget {
    private final MemoryImage memoryImage;
    private final Subscription webDialogCreated;

    GraphicsRenderWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, widget);
        BrowserImpl browser = widget.browser();
        this.memoryImage = new MemoryImage();
        if (Environment.isLinux()) {
            this.addPaintListener(e -> {
                Transform swtTransform = new Transform(e.gc.getDevice());
                e.gc.getTransform(swtTransform);
                double scale = 1.0 / this.memoryImage.deviceScaleFactor();
                swtTransform.scale((float)scale, (float)scale);
                e.gc.setTransform(swtTransform);
                GraphicsRenderWidget graphicsRenderWidget = this;
                synchronized (graphicsRenderWidget) {
                    this.memoryImage.image().ifPresent(image -> e.gc.drawImage(image, 0, 0));
                }
                swtTransform.dispose();
                widget.onPainted();
            });
        }
        this.webDialogCreated = widget.on(WebDialogCreated.class, event -> SafeExecutor.asyncExec((Widget)this, () -> {
            WebDialog webDialog = new WebDialog(browser, event.getWebDialogId());
            GraphicsWebDialogView webDialogView = new GraphicsWebDialogView(this, webDialog, (com.teamdev.jxbrowser.ui.Rect)event.getInitialBounds(), event.getScaleFactor());
            webDialog.on(DialogBoundsUpdated.class, e -> SafeExecutor.asyncExec((Widget)this, () -> webDialogView.moveToTopCenter((com.teamdev.jxbrowser.ui.Rect)e.getBounds(), e.getScaleFactor())));
            webDialog.on(DialogClosed.class, e -> SafeExecutor.asyncExec((Widget)this, () -> ((GraphicsWebDialogView)webDialogView).dispose()));
            webDialogView.redraw();
        }));
        widget.set(PaintCallback.class, (BrowserWidgetCallback)new OnPaint());
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        super.showRenderWidget();
        this.redraw();
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        super.hideRenderWidget();
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    @Override
    protected void close() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.remove(PaintCallback.class);
        }
        this.webDialogCreated.unsubscribe();
        super.close();
    }

    private void redrawIfShown() {
        if (this.isShown()) {
            this.redraw();
        }
    }

    private final class OnPaint
    implements PaintCallback {
        private OnPaint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Paint.Response on(Paint.Request params) {
            PaintRequest request = params.getPaintRequest();
            com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
            Rect dirtyRect = request.getDirtyRect();
            if (!GraphicsRenderWidget.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                return Paint.Response.newBuilder().build();
            }
            int width = viewSize.width();
            int height = viewSize.height();
            long memoryId = request.getMemoryId().getValue();
            if (Environment.isWindows()) {
                ToolkitLibrary.instance().drawPixels(GraphicsRenderWidget.this.nativeHandle(), width, height, memoryId);
                GraphicsRenderWidget.this.browserWidget().onPainted();
            } else if (Environment.isLinux()) {
                GraphicsRenderWidget graphicsRenderWidget = GraphicsRenderWidget.this;
                synchronized (graphicsRenderWidget) {
                    GraphicsRenderWidget.this.memoryImage.updatePixels(GraphicsRenderWidget.this, (Size)viewSize, (com.teamdev.jxbrowser.ui.Rect)dirtyRect, request.getMemoryId(), request.getScaleFactor(), rect -> GraphicsRenderWidget.this.redrawIfShown());
                }
            }
            return Paint.Response.newBuilder().build();
        }
    }
}

