/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.LinuxFocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.TabbingAssistant;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.swt.internal.WindowsFocusAdapter;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

abstract class FocusAdapter {
    private final Listener whenFocusedIn;
    private final Listener whenShellDeactivated;
    private final WindowedWidget windowedWidget;
    private final TabbingAssistant tabbingAssistant;
    private boolean started;
    private @MonotonicNonNull Subscription focusGained;
    private @MonotonicNonNull Subscription focusLost;
    private @MonotonicNonNull Subscription doneTabbing;

    FocusAdapter(WindowedWidget windowedWidget) {
        this.windowedWidget = windowedWidget;
        this.whenFocusedIn = this::onSwtWidgetFocusedIn;
        this.whenShellDeactivated = this::onShellDeactivated;
        this.tabbingAssistant = new TabbingAssistant(windowedWidget.getParent());
    }

    static FocusAdapter newInstance(WindowedWidget jxComposite) {
        if (Environment.isLinux()) {
            return new LinuxFocusAdapter(jxComposite);
        }
        if (Environment.isWindows()) {
            return new WindowsFocusAdapter(jxComposite);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    final void startEventProcessing() {
        Display display = this.windowedWidget.getDisplay();
        display.addFilter(15, this.whenFocusedIn);
        display.addFilter(27, this.whenShellDeactivated);
        BrowserWidget browserWidget = this.windowedWidget.browserWidget();
        this.doneTabbing = browserWidget.on(DoneTabbing.class, this::onDoneTabbing);
        BrowserImpl browser = browserWidget.browser();
        this.focusGained = browser.on(FocusGained.class, this::on);
        this.focusLost = browser.on(FocusLost.class, this::on);
        this.started = true;
    }

    final void stopEventProcessing() {
        if (this.started) {
            Display display = this.windowedWidget.getDisplay();
            display.removeFilter(15, this.whenFocusedIn);
            display.removeFilter(27, this.whenShellDeactivated);
            this.focusGained.unsubscribe();
            this.focusLost.unsubscribe();
            this.doneTabbing.unsubscribe();
        }
        this.started = false;
    }

    protected abstract void on(FocusLost var1);

    protected abstract void on(FocusGained var1);

    protected abstract void onSwtWidgetFocusedIn(Event var1);

    WindowedWidget windowedWidget() {
        return this.windowedWidget;
    }

    private void onDoneTabbing(DoneTabbing event) {
        SafeExecutor.asyncExec((Widget)this.windowedWidget, () -> {
            if (event.getReason() == DoneTabbing.Reason.DONE_TABBING_PREV) {
                this.tabbingAssistant.passFocusToPrev();
            } else {
                this.tabbingAssistant.passFocusToNext();
            }
        });
    }

    private void onShellDeactivated(Event event) {
        if (this.windowedWidget.isDisposed()) {
            return;
        }
        Widget deactivatedWidget = event.widget;
        if (this.windowedWidget.getShell().equals(deactivatedWidget)) {
            this.windowedWidget.unfocusBrowserWidget();
        }
    }
}

