/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Shell;

class DisplayWatcher {
    private final ShellListener shellListener;
    private final Observer observer;
    private Display display;
    private Shell shell;
    private long windowHandle;
    private boolean attached;

    private DisplayWatcher(Observer observer) {
        this.observer = observer;
        this.shellListener = new ShellListener();
        this.attached = false;
    }

    static DisplayWatcher newInstance(Observer observer) {
        Preconditions.checkNotNull((Object)observer);
        if (DisplayWatcher.shouldWatchDisplay()) {
            return new DisplayWatcher(observer);
        }
        return new NopDisplayWatcher();
    }

    static DisplayWatcher nopDisplayWatcher() {
        return new NopDisplayWatcher();
    }

    private void updateDisplay() {
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.instance();
        String displayId = toolkitLibrary.getDisplayIdForWindow(this.windowHandle);
        if (this.isDisplayChanged(displayId)) {
            double scaleFactor = toolkitLibrary.getScaleFactorForDisplay(displayId);
            this.display = new Display(displayId, scaleFactor);
            this.observer.onDisplayChanged(this.display);
        }
    }

    private boolean isDisplayChanged(String newDisplayId) {
        return this.display == null || !this.display.id().equals(newDisplayId);
    }

    void attach(NativeAwareControl control) {
        Preconditions.checkNotNull((Object)control);
        if (Environment.isLinux()) {
            return;
        }
        this.shell = control.getShell();
        if (this.shell == null) {
            return;
        }
        long windowHandle = control.nativeHandle();
        if (this.attached) {
            if (windowHandle != this.windowHandle) {
                throw this.cannotAttach(windowHandle);
            }
            return;
        }
        this.shell.addControlListener((ControlListener)this.shellListener);
        this.windowHandle = windowHandle;
        this.updateDisplay();
        this.attached = true;
    }

    void detach() {
        if (Environment.isLinux()) {
            return;
        }
        if (!this.attached) {
            return;
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.removeControlListener((ControlListener)this.shellListener);
        }
        this.attached = false;
    }

    private IllegalStateException cannotAttach(long windowHandle) {
        throw new IllegalStateException(String.format("Failed to attach to the handle `%d` due to being attached to the other handle: `%d`. Make sure to call detach() first.", windowHandle, this.windowHandle));
    }

    private static boolean shouldWatchDisplay() {
        return !SystemProperties.hasProperty((String)"jxbrowser.display.watcher.off");
    }

    private static final class NopDisplayWatcher
    extends DisplayWatcher {
        private NopDisplayWatcher() {
            super(null);
        }

        @Override
        void attach(NativeAwareControl control) {
        }

        @Override
        void detach() {
        }
    }

    private class ShellListener
    extends ControlAdapter {
        private ShellListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            DisplayWatcher.this.updateDisplay();
        }

        public void controlMoved(ControlEvent e) {
            DisplayWatcher.this.updateDisplay();
        }
    }

    static interface Observer {
        public void onDisplayChanged(Display var1);
    }
}

