/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swt.internal.FirstAppearanceDetector;
import com.teamdev.jxbrowser.view.swt.internal.GraphicsRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.IoSurfaceRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareShell;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.ShellListeners;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class BrowserComposite
extends Composite {
    private final BrowserWidget browserWidget;
    private final ShellListeners shellListeners;
    private final DisplayWatcher displayWatcher;
    private final FirstAppearanceDetector firstAppearanceDetector;
    private Shell lastKnownShell;

    public static BrowserComposite create(BrowserView view, BrowserWidget widget) {
        Preconditions.checkNotNull((Object)((Object)view));
        Preconditions.checkNotNull((Object)widget);
        if (Environment.isMac()) {
            return new IoSurfaceRenderWidget(view, widget);
        }
        RenderingMode renderingMode = widget.browser().engine().options().renderingMode();
        if (renderingMode == RenderingMode.OFF_SCREEN) {
            return new GraphicsRenderWidget(view, widget);
        }
        if (renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
            return new WindowedWidget(view, widget);
        }
        throw new IllegalArgumentException("Unsupported rendering mode");
    }

    BrowserComposite(Composite parent, int style, BrowserWidget browserWidget) {
        super(parent, style);
        this.browserWidget = browserWidget;
        this.firstAppearanceDetector = new FirstAppearanceDetector(this);
        this.firstAppearanceDetector.startEventProcessing();
        this.shellListeners = new ShellListeners(this);
        this.displayWatcher = DisplayWatcher.newInstance(this::onMovedToDisplay);
        this.lastKnownShell = parent.getShell();
    }

    abstract void showRenderWidget();

    abstract void notifyBoundsUpdated();

    public final void reskin(int flags) {
        super.reskin(flags);
        this.onHierarchyChanged();
    }

    protected void onHierarchyChanged() {
        Shell currentShell = this.getShell();
        if (this.lastKnownShell != currentShell) {
            SafeExecutor.asyncExec((Widget)this, () -> {
                this.lastKnownShell = currentShell;
                this.onShellChanged();
            });
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void onMovedToDisplay(Display display) {
        this.browserWidget.displayId(display.id());
    }

    @OverridingMethodsMustInvokeSuper
    private void onShellChanged() {
        Shell newShell = this.getShell();
        this.shellListeners.detach();
        this.shellListeners.attach(newShell);
        this.displayWatcher.detach();
        this.displayWatcher.attach(new NativeAwareShell(newShell));
    }

    protected void close() {
        this.firstAppearanceDetector.stopEventProcessing();
    }

    protected ShellListeners shellListeners() {
        return this.shellListeners;
    }

    BrowserWidget browserWidget() {
        return this.browserWidget;
    }

    DisplayWatcher displayWatcher() {
        return this.displayWatcher;
    }
}

