/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DefaultOpenPopupCallback
extends DefaultCallback
implements OpenPopupCallback {
    private static final int DEFAULT_POPUP_WIDTH = 800;
    private static final int DEFAULT_POPUP_HEIGHT = 600;

    public DefaultOpenPopupCallback(Composite parent) {
        super(parent);
    }

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        Browser browser = params.popupBrowser();
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            Display display = ((Composite)this.widget()).getDisplay();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout());
            BrowserView view = BrowserView.newInstance((Composite)shell, browser);
            DefaultOpenPopupCallback.updateBounds(shell, view, params.initialBounds());
            shell.addDisposeListener(event -> {
                if (!browser.isClosed()) {
                    SafeExecutor.asyncExec((Widget)shell, () -> ((Browser)browser).close());
                }
            });
            browser.on(TitleChanged.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> shell.setText(event.title())));
            browser.on(BrowserClosed.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> ((Shell)shell).dispose()));
            browser.on(UpdateBoundsRequested.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> DefaultOpenPopupCallback.updateBounds(shell, view, event.bounds())));
            view.setVisible(true);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }, OpenPopupCallback.Response::proceed);
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(Shell shell, BrowserView view, Rect bounds) {
        shell.setLocation(bounds.x(), bounds.y());
        if (bounds.size().isEmpty()) {
            view.setSize(800, 600);
        } else {
            view.setSize(bounds.width(), bounds.height());
        }
    }
}

