/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback;

import com.teamdev.jxbrowser.browser.callback.OpenFileCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import java.nio.file.Paths;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

public final class DefaultOpenFileCallback
extends DefaultCallback
implements OpenFileCallback {
    public DefaultOpenFileCallback(Composite parent) {
        super(parent);
    }

    public void on(OpenFileCallback.Params params, OpenFileCallback.Action tell) {
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            FileDialog dialog = new FileDialog(((Composite)this.widget()).getShell(), 4096);
            dialog.setText(params.filterDescription());
            StringBuilder builder = new StringBuilder();
            params.acceptableExtensions().forEach(extension -> builder.append("*.").append((String)extension).append(';'));
            dialog.setFilterExtensions(new String[]{builder.toString(), "*.*"});
            String filePath = dialog.open();
            if (filePath != null) {
                tell.open(Paths.get(filePath, new String[0]));
            } else {
                tell.cancel();
            }
        }, () -> ((OpenFileCallback.Action)tell).cancel());
    }
}

