/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd.parser;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Optional;

public final class UrlTransferableParser
implements TransferableParser {
    private static DataFlavor urlFlavor;
    private static DataFlavor uriFlavor;

    public static boolean isDataFormat(String text) {
        return text != null && !text.isEmpty() && text.startsWith("data:");
    }

    @Override
    public boolean canParse(Transferable transferable) {
        return transferable.isDataFlavorSupported(urlFlavor) || transferable.isDataFlavorSupported(uriFlavor);
    }

    @Override
    public void parse(Transferable transferable, DropData.Builder builder) {
        try {
            if (transferable.isDataFlavorSupported(uriFlavor)) {
                if (Environment.isMac()) {
                    Optional.ofNullable(ToolkitLibrary.instance().readUrlFromPasteboard()).ifPresent(arg_0 -> ((DropData.Builder)builder).setUrl(arg_0));
                } else {
                    String uriList = (String)transferable.getTransferData(uriFlavor);
                    String url = UrlTransferableParser.getFirstUrl(uriList);
                    builder.setUrl(url);
                }
                return;
            }
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to parse transferable.", (Object[])new Object[]{e});
        }
        try {
            if (transferable.isDataFlavorSupported(urlFlavor)) {
                builder.setUrl(transferable.getTransferData(urlFlavor).toString());
                return;
            }
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to parse transferable.", (Object[])new Object[]{e});
        }
    }

    @Override
    public void parse(Transferable transferable, DropMetadata.Builder builder) {
        builder.setContainsUrl(this.canParse(transferable));
    }

    private static String getFirstUrl(String uriList) {
        return uriList.split("\r\n", -1)[0];
    }

    static {
        try {
            urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
            uriFlavor = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to initialize UrlTransferableParser: ", (Object[])new Object[]{e});
        }
    }
}

