/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd.parser;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;

public final class HtmlTransferableParser
implements TransferableParser {
    private static final List<DataFlavor> supportedDataFlavors = new ArrayList<DataFlavor>();

    @Override
    public boolean canParse(Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            if (!supportedDataFlavors.contains(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(Transferable transferable, DropData.Builder builder) {
        for (DataFlavor dataFlavor : supportedDataFlavors) {
            try {
                if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                String rawHtml = (String)transferable.getTransferData(dataFlavor);
                if (Environment.isWindows()) {
                    builder.setHtml(HtmlTransferableParser.clearHtml(rawHtml));
                } else {
                    builder.setHtml(rawHtml);
                }
                return;
            }
            catch (Exception e) {
                Logger.debug((String)"Failed to parse transferable.", (Object[])new Object[]{e});
            }
        }
    }

    @Override
    public void parse(Transferable transferable, DropMetadata.Builder builder) {
        builder.setContainsHtml(this.canParse(transferable));
    }

    private static String clearHtml(String rawHtml) {
        int startIndex;
        String result = rawHtml.startsWith("Version:") ? ((startIndex = rawHtml.indexOf(60)) >= 0 ? rawHtml.substring(startIndex) : "") : rawHtml;
        return result;
    }

    static {
        try {
            supportedDataFlavors.add(new DataFlavor("text/html; class=java.lang.String"));
            supportedDataFlavors.add(DataFlavor.fragmentHtmlFlavor);
            supportedDataFlavors.add(DataFlavor.allHtmlFlavor);
            supportedDataFlavors.add(DataFlavor.selectionHtmlFlavor);
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to initialize HtmlTransferableParser: ", (Object[])new Object[]{e});
        }
    }
}

