/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd.parser;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;

public final class FileTransferableParser
implements TransferableParser {
    @Override
    public boolean canParse(Transferable transferable) {
        return transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public void parse(Transferable transferable, DropData.Builder builder) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    builder.addFile(com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder().setFilePath(file.getAbsolutePath()).build());
                }
                return;
            }
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to parse transferable.", (Object[])new Object[]{e});
        }
    }

    @Override
    public void parse(Transferable transferable, DropMetadata.Builder builder) {
        builder.setContainsFiles(this.canParse(transferable));
    }
}

