/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyLocation;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swing.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.SwingCursorFactory;
import com.teamdev.jxbrowser.view.swing.internal.Widget;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragAndDropHelper;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class OffScreenRenderWidget
extends JComponent
implements Widget {
    private final KeyListener keyListener;
    private final MouseListener mouseListener;
    private final FocusListener focusListener;
    private final ComponentListener resizeListener;
    private final WindowListener windowIconifiedListener;
    private final MouseWheelListener mouseWheelListener;
    private final ComponentListener windowMovedListener;
    private final HierarchyListener hierarchyListener;
    private final BrowserWidget widget;
    private final Subscription browserClosed;
    private final NativeKeyCodes nativeKeyCodes;
    private final SwingCursorFactory cursorFactory;
    private final AwtHelperLibrary awtHelperLibrary;
    private final Lazy<DragAndDropHelper> dragAndDropHelper;
    private int lastKeyCode;
    private Display display;
    private DisplayWatcher displayWatcher;
    private Subscription doneTabbing;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private boolean visible;

    OffScreenRenderWidget(BrowserWidget widget) {
        this.widget = widget;
        this.nativeKeyCodes = new NativeKeyCodes();
        this.awtHelperLibrary = AwtHelperLibrary.instance();
        this.focusListener = new FocusListener();
        this.resizeListener = new ResizeListener();
        this.keyListener = new KeyListener();
        this.mouseListener = new MouseListener();
        this.mouseWheelListener = new MouseWheelListener();
        this.windowMovedListener = new WindowMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        this.hierarchyListener = new HierarchyListenerImpl();
        this.display = Display.primaryDisplay();
        if (!SystemProperties.hasProperty((String)"jxbrowser.display.watcher.off")) {
            this.displayWatcher = new DisplayWatcher(this::onDisplayChanged);
        }
        this.dragAndDropHelper = new Lazy(() -> {
            if (!GraphicsEnvironment.isHeadless()) {
                return new DragAndDropHelper(this, widget, this.display);
            }
            return null;
        });
        this.cursorFactory = new SwingCursorFactory();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setIgnoreRepaint(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(2088L);
        this.browserClosed = widget.browser().on(BrowserClosed.class, event -> this.close());
    }

    private Optional<DisplayWatcher> displayWatcher() {
        return Optional.ofNullable(this.displayWatcher);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this.hierarchyListener);
        this.showRenderWidget();
    }

    @Override
    public void removeNotify() {
        this.hideRenderWidget();
        this.removeHierarchyListener(this.hierarchyListener);
        super.removeNotify();
    }

    boolean isShown() {
        return this.visible;
    }

    protected void close() {
        this.hideRenderWidget();
        this.browserClosed.unsubscribe();
    }

    final BrowserWidget widget() {
        return this.widget;
    }

    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        this.updateMouseListeners();
        this.addWindowListeners();
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.addComponentListener(this.resizeListener);
        this.widget.show();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            if (!SystemProperties.hasProperty((String)"jxbrowser.desktop.headless.on")) {
                this.widget.attach(this.awtHelperLibrary.getWindowHandle(window));
            }
            this.notifyBoundsUpdated();
            this.widget.show();
        }
        this.cursorChanged = this.widget.on(CursorChanged.class, event -> {
            try {
                Cursor cursor = (Cursor)this.cursorFactory.newCursor((CursorChanged)event);
                SwingUtilities.invokeLater(() -> this.setCursor(cursor));
            }
            catch (Exception e) {
                Logger.error((String)"Failed to change cursor", (Throwable)e);
            }
        });
        this.tooltipChanged = this.widget.on(TooltipChanged.class, event -> SwingUtilities.invokeLater(() -> {
            String text = event.getTooltipText();
            if (text.isEmpty()) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(text);
            }
        }));
        this.doneTabbing = this.widget.on(DoneTabbing.class, event -> SwingUtilities.invokeLater(() -> {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (event.getReason() == DoneTabbing.Reason.DONE_TABBING_NEXT) {
                focusManager.focusNextComponent();
            } else {
                focusManager.focusPreviousComponent();
            }
        }));
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).attach();
        }
        this.notifyBoundsUpdated();
        this.visible = true;
    }

    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.cursorChanged.unsubscribe();
        this.tooltipChanged.unsubscribe();
        this.doneTabbing.unsubscribe();
        if (!this.widget.isClosed()) {
            if (this.isDragAndDropEnabled()) {
                ((DragAndDropHelper)this.dragAndDropHelper.get()).detach();
            }
            this.widget.hide();
        }
        this.removeKeyListener(this.keyListener);
        this.removeFocusListener(this.focusListener);
        this.removeComponentListener(this.resizeListener);
        this.removeWindowListeners();
        this.updateMouseListeners();
        this.visible = false;
    }

    private void addWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addComponentListener(this.windowMovedListener);
            window.addWindowListener(this.windowIconifiedListener);
            this.displayWatcher().ifPresent(watcher -> watcher.attach(window));
        }
    }

    protected void removeWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.windowMovedListener);
            window.removeWindowListener(this.windowIconifiedListener);
            this.displayWatcher().ifPresent(watcher -> watcher.detach(window));
        }
    }

    private void updateMouseListeners() {
        if (this.isEnabled()) {
            this.addMouseListener(this.mouseListener);
            this.addMouseWheelListener(this.mouseWheelListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseWheelListener(this.mouseWheelListener);
        }
    }

    @Override
    public synchronized void addMouseListener(java.awt.event.MouseListener l) {
        if (!Arrays.asList(this.getMouseListeners()).contains(l)) {
            super.addMouseListener(l);
        }
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (!Arrays.asList(this.getMouseMotionListeners()).contains(l)) {
            super.addMouseMotionListener(l);
        }
    }

    @Override
    public synchronized void addMouseWheelListener(java.awt.event.MouseWheelListener l) {
        if (!Arrays.asList(this.getMouseWheelListeners()).contains(l)) {
            super.addMouseWheelListener(l);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateMouseListeners();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.notifyBoundsUpdated();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.widget.show();
        } else {
            this.widget.hide();
        }
    }

    private void notifyBoundsUpdated() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        java.awt.Point locationOnScreen = this.getLocationOnScreen();
        if (bounds.width < 0 || bounds.height < 0) {
            return;
        }
        bounds.setLocation(ComponentLocator.locationInWindow(this));
        Rect boundsInWindow = Geometry.newRect((double)bounds.x, (double)bounds.y, (double)bounds.width, (double)bounds.height);
        Rect boundsInScreen = Geometry.newRect((double)locationOnScreen.x, (double)locationOnScreen.y, (double)bounds.width, (double)bounds.height);
        if (!Platform.instance().isDpiAware()) {
            boundsInWindow = Geometry.scaleDown((Rect)boundsInWindow, (double)this.display.scaleFactor());
            boundsInScreen = Geometry.scaleDown((Rect)boundsInScreen, (double)this.display.scaleFactor());
        }
        this.widget.bounds(boundsInWindow, boundsInScreen);
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.dragAndDropHelper.maybeGet().ifPresent(helper -> helper.onDisplayChanged(display));
        this.widget.displayId(display.id());
    }

    private Point screenPoint(MouseEvent e) {
        java.awt.Point location = ComponentLocator.locationOnScreen(e.getComponent());
        int x = e.getX();
        int y = e.getY();
        int globalX = location.x + x;
        int globalY = location.y + y;
        Point point = Geometry.newPoint((double)globalX, (double)globalY);
        if (!Platform.instance().isDpiAware()) {
            return Geometry.scaleDown((Point)point, (double)this.display.scaleFactor());
        }
        return point;
    }

    private Point localPoint(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point point = Geometry.newPoint((double)x, (double)y);
        if (!Platform.instance().isDpiAware()) {
            return Geometry.scaleDown((Point)point, (double)this.display.scaleFactor());
        }
        return point;
    }

    private void dispatchMouseDragged(MouseEvent e) {
        this.widget.dispatch(MouseDragged.newBuilder((Point)this.localPoint(e)).locationOnScreen(this.screenPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
    }

    private static KeyModifiers keyModifiers(InputEvent e) {
        return KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e)).build();
    }

    private static KeyModifiers keyModifiers(MouseEvent e) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e));
        if (SwingUtilities.isRightMouseButton(e)) {
            builder.metaDown(false);
        }
        return builder.build();
    }

    private static KeyLocation keyLocation(KeyEvent e) {
        if (e.getKeyLocation() == 4) {
            return KeyLocation.NUMERIC_KEYPAD;
        }
        if (e.getKeyLocation() == 2) {
            return KeyLocation.LEFT;
        }
        if (e.getKeyLocation() == 3) {
            return KeyLocation.RIGHT;
        }
        return KeyLocation.STANDARD;
    }

    private static MouseModifiers mouseModifiers(MouseEvent e) {
        int modifiersEx = e.getModifiersEx();
        return MouseModifiers.newBuilder().primaryButtonDown((modifiersEx & 0x400) == 1024).middleButtonDown((modifiersEx & 0x800) == 2048).secondaryButtonDown((modifiersEx & 0x1000) == 4096).build();
    }

    private void dispatchMouseMoved(MouseEvent e) {
        this.widget.dispatch(MouseMoved.newBuilder((Point)this.localPoint(e)).locationOnScreen(this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
    }

    static MouseButton mouseButton(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            return MouseButton.PRIMARY;
        }
        if (SwingUtilities.isMiddleMouseButton(event)) {
            return MouseButton.MIDDLE;
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            return MouseButton.SECONDARY;
        }
        if (event.getButton() == 0) {
            return MouseButton.NO_BUTTON;
        }
        return MouseButton.MOUSE_BUTTON_UNSPECIFIED;
    }

    private static boolean isShiftDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x40) != 0 : event.isShiftDown();
    }

    private static boolean isControlDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x80) != 0 : event.isControlDown();
    }

    private static boolean isMetaDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x100) != 0 : event.isMetaDown();
    }

    private static boolean isAltDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x200) != 0 : event.isAltDown();
    }

    private static boolean isAltGraphDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x2000) != 0 : event.isAltGraphDown();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getID() == 503) {
            super.processMouseMotionEvent(e);
            this.dispatchMouseMoved(e);
            return;
        }
        if (e.getID() == 506) {
            if (this.isDragging()) {
                super.processMouseMotionEvent(e);
                return;
            }
            this.dispatchMouseDragged(e);
        }
    }

    private boolean isDragging() {
        return this.dragAndDropHelper.maybeGet().map(DragAndDropHelper::isDragging).orElse(false);
    }

    private void requestFocusIfNecessary() {
        if (!this.hasFocus()) {
            this.requestFocus();
        }
    }

    @Override
    public void enableDragAndDrop() {
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).attach();
        }
    }

    @Override
    public void disableDragAndDrop() {
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).detach();
        }
    }

    private boolean isDragAndDropEnabled() {
        return this.widget.browser().dragAndDrop().isEnabled();
    }

    private class HierarchyListenerImpl
    implements HierarchyListener {
        private HierarchyListenerImpl() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 4L) {
                if (OffScreenRenderWidget.this.isShowing()) {
                    OffScreenRenderWidget.this.showRenderWidget();
                } else {
                    OffScreenRenderWidget.this.hideRenderWidget();
                }
            }
        }
    }

    private class WindowIconifiedListener
    extends WindowAdapter {
        private WindowIconifiedListener() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            OffScreenRenderWidget.this.widget.minimize();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            OffScreenRenderWidget.this.widget.restore();
        }
    }

    private class WindowMovedListener
    extends ComponentAdapter {
        private WindowMovedListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            OffScreenRenderWidget.this.notifyBoundsUpdated();
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (OffScreenRenderWidget.this.isEnabled()) {
                OffScreenRenderWidget.this.widget.focus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (OffScreenRenderWidget.this.isEnabled()) {
                OffScreenRenderWidget.this.widget.unfocus();
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            OffScreenRenderWidget.this.widget.dispatch(KeyTyped.newBuilder((KeyCode)OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(OffScreenRenderWidget.this.lastKeyCode != 0 ? OffScreenRenderWidget.this.lastKeyCode : e.getKeyCode(), e.getKeyLocation())).keyChar(e.getKeyChar()).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.suppressTraversalKey(e);
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(e.getKeyCode(), e.getKeyLocation());
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = e.getKeyCode();
            KeyPressed.Builder builder = KeyPressed.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).keyLocation(OffScreenRenderWidget.keyLocation(e));
            char keyChar = e.getKeyChar();
            if (keyChar != '\uffff' && !this.isSystemKey(e)) {
                builder.keyChar(keyChar);
            }
            OffScreenRenderWidget.this.widget.dispatch(builder.build());
        }

        private boolean isSystemKey(KeyEvent e) {
            return e.getKeyCode() == 10;
        }

        private void suppressTraversalKey(KeyEvent event) {
            if (event.getKeyChar() == '\t') {
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(e.getKeyCode(), e.getKeyLocation());
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = 0;
            OffScreenRenderWidget.this.widget.dispatch(KeyReleased.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).keyLocation(OffScreenRenderWidget.keyLocation(e)).build());
        }
    }

    private class MouseWheelListener
    extends MouseAdapter {
        private MouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            int directionFix = -1;
            ScrollType scrollType = ScrollType.forNumber((int)e.getScrollType());
            if (scrollType == null) {
                scrollType = ScrollType.SCROLL_TYPE_UNSPECIFIED;
            }
            float pointsPerUnit = Environment.isMac() ? 10.0f : 33.333332f;
            float delta = (float)e.getUnitsToScroll() * pointsPerUnit * (float)directionFix;
            float deltaX = e.isShiftDown() ? delta : 0.0f;
            float deltaY = !e.isShiftDown() ? delta : 0.0f;
            OffScreenRenderWidget.this.widget.dispatch(MouseWheel.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).deltaX(deltaX).deltaY(deltaY).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).scrollType(scrollType).build());
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseEntered.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseExited.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.requestFocusIfNecessary();
            OffScreenRenderWidget.this.widget.dispatch(MousePressed.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseReleased.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }
    }
}

