/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class FileChooser {
    private final JFileChooser fileChooser = new JFileChooser();

    public FileChooser(String filterDescription, List<String> extensions) {
        this.setupExtensionFilters(filterDescription, extensions);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.fileChooser.setMultiSelectionEnabled(enabled);
    }

    public int showOpenDialog(Component parent) {
        return this.fileChooser.showOpenDialog(parent);
    }

    public File selectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public File[] selectedFiles() {
        return this.fileChooser.getSelectedFiles();
    }

    private void setupExtensionFilters(String filterDescription, List<String> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter(filterDescription, extensions.toArray(new String[0]));
        this.fileChooser.addChoosableFileFilter(filter);
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter acceptAllFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All files";
            }
        };
        this.fileChooser.addChoosableFileFilter(acceptAllFilter);
    }
}

