/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

final class DisplayWatcher {
    private final Observer observer;
    private final WindowListener windowListener;
    private final AwtHelperLibrary awtHelperLibrary;
    private Display display;
    private long windowHandle;

    DisplayWatcher(Observer observer) {
        this.observer = observer;
        this.windowListener = new WindowListener();
        this.awtHelperLibrary = AwtHelperLibrary.instance();
    }

    private void updateDisplay() {
        String displayId = ToolkitLibrary.instance().getDisplayIdForWindow(this.windowHandle);
        if (this.isDisplayChanged(displayId)) {
            this.display = new Display(displayId, this.scaleFactor(displayId));
            this.observer.onDisplayChanged(this.display);
        }
    }

    private boolean isDisplayChanged(String newDisplayId) {
        return this.display == null || !this.display.id().equals(newDisplayId);
    }

    void attach(Window window) {
        if (Environment.isLinux()) {
            return;
        }
        if (window != null) {
            window.addComponentListener(this.windowListener);
            if (!SystemProperties.hasProperty((String)"jxbrowser.desktop.headless.on")) {
                this.windowHandle = this.awtHelperLibrary.getWindowHandle(window);
            }
            this.updateDisplay();
        }
    }

    void detach(Window window) {
        if (Environment.isLinux()) {
            return;
        }
        if (window != null) {
            window.removeComponentListener(this.windowListener);
        }
    }

    private double scaleFactor(String displayId) {
        String property = System.getProperty("jxbrowser.force.device.scale.factor");
        if (property != null) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(e);
            }
        }
        return ToolkitLibrary.instance().getScaleFactorForDisplay(displayId);
    }

    private class WindowListener
    extends ComponentAdapter {
        private WindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DisplayWatcher.this.updateDisplay();
        }
    }

    public static interface Observer {
        public void onDisplayChanged(Display var1);
    }
}

