/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class DefaultOpenPopupCallback
implements OpenPopupCallback {
    private static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        final Browser browser = params.popupBrowser();
        SwingUtilities.invokeLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            JFrame frame = new JFrame();
            frame.add((Component)view, "Center");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingUtilities.invokeLater(() -> ((Browser)browser).close());
                }
            });
            DefaultOpenPopupCallback.updateBounds(frame, params.initialBounds(), params.scaleFactor());
            browser.on(TitleChanged.class, event -> SwingUtilities.invokeLater(() -> frame.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> SwingUtilities.invokeLater(() -> {
                frame.setVisible(false);
                frame.dispose();
            }));
            browser.on(UpdateBoundsRequested.class, event -> SwingUtilities.invokeLater(() -> DefaultOpenPopupCallback.updateBounds(frame, event.bounds(), event.scaleFactor())));
            frame.setVisible(true);
        });
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(JFrame frame, Rect bounds, double scaleFactor) {
        DefaultOpenPopupCallback.updateOrigin(frame, bounds.origin(), scaleFactor);
        DefaultOpenPopupCallback.updateSize(frame, bounds.size(), scaleFactor);
        frame.pack();
    }

    private static void updateOrigin(JFrame frame, Point origin, double scaleFactor) {
        if (DefaultOpenPopupCallback.shouldAdjustScaling()) {
            origin = Geometry.scaleUp((Point)origin, (double)scaleFactor);
        }
        frame.setLocation(ToolkitConverters.toPoint(origin));
    }

    private static void updateSize(JFrame frame, Size size, double scaleFactor) {
        if (size.isEmpty()) {
            frame.setSize(ToolkitConverters.toDimension(DEFAULT_POPUP_SIZE));
            return;
        }
        if (DefaultOpenPopupCallback.shouldAdjustScaling()) {
            size = Geometry.scaleUp((Size)size, (double)scaleFactor);
        }
        frame.getContentPane().setPreferredSize(ToolkitConverters.toDimension(size));
    }

    private static boolean shouldAdjustScaling() {
        return !Platform.instance().isDpiAware();
    }
}

