/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress.internal.drawing;

import android.content.res.TypedArray;
import com.teachonmars.modules.widget.segmentedProgress.R;

public class SectionsCounter {
    private int nbSection;
    private int showCount = 2;

    public int getCount() {
        return this.nbSection;
    }

    public int getShowCount() {
        return this.showCount;
    }

    public void loadFromResources(TypedArray a, boolean inEditMode) {
        this.nbSection = !inEditMode ? a.getInt(R.styleable.SegmentedProgress_nbSection, R.integer.segmentedProgressDefaults_nbSection) : 5;
    }

    int calculateFuturCount(float progressPercent) {
        int newCount = (int)(progressPercent * (float)this.nbSection);
        return Math.min(newCount, this.nbSection);
    }

    void setShowCount(int showCount) {
        this.showCount = showCount <= this.nbSection ? showCount : this.nbSection;
    }

    public int setProgress(float progressPercent) {
        this.showCount = this.calculateFuturCount(progressPercent);
        return this.showCount;
    }

    public void setNbSection(int nbSection) {
        if (nbSection < 1) {
            nbSection = 1;
        }
        if (this.showCount > nbSection) {
            this.showCount = nbSection;
        }
        this.nbSection = nbSection;
    }
}

