/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress.internal.drawing;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import com.teachonmars.modules.widget.segmentedProgress.R;
import com.teachonmars.modules.widget.segmentedProgress.SegmentedProgress;

public class DrawableManager {
    public static final int[] STATE_SHOW_FRONT = new int[]{R.attr.segmentedProgressStyle_stateShowFront};
    public static final int[] STATE_SHOW_BACK = new int[]{R.attr.segmentedProgressStyle_stateShowBack};
    private SegmentedProgress view;
    private StateListDrawable stateDrawable;
    private boolean preventInvalidation;
    private int backgroundColor;
    private ClipDrawable progressDrawable;

    public DrawableManager(SegmentedProgress view) {
        this.view = view;
    }

    public void loadFromResources(TypedArray a, boolean inEditMode) {
        this.backgroundColor = !inEditMode ? a.getColor(R.styleable.SegmentedProgress_colorEmpty, 0) : -7829368;
        this.preventInvalidation = true;
        this.retrieveImageDrawable(a, R.styleable.SegmentedProgress_android_src);
        this.preventInvalidation = false;
    }

    public void draw(Canvas canvas) {
        if (this.stateDrawable != null) {
            this.stateDrawable.draw(canvas);
        }
    }

    public void setState(int[] state) {
        if (this.stateDrawable != null) {
            this.stateDrawable.setState(state);
        }
    }

    public void setDrawable(@DrawableRes int resId) {
        if (resId != 0) {
            Drawable d = ContextCompat.getDrawable((Context)this.view.getContext(), (int)resId);
            this.setImageDrawable(d);
        } else {
            this.failImageNotProvided();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        this.cleanDrawables();
        this.ensureNewDrawable(drawable);
        this.stateDrawable = this.buildStateDrawable(drawable);
        this.stateDrawable.setCallback((Drawable.Callback)this.view);
        this.stateDrawable.setState(STATE_SHOW_FRONT);
        this.progressDrawable = this.buildProgressDrawable((Drawable)this.stateDrawable);
        this.progressDrawable.setState(STATE_SHOW_FRONT);
        if (Build.VERSION.SDK_INT >= 17) {
            int layoutDirection = this.view.getLayoutDirection();
            DrawableCompat.setLayoutDirection((Drawable)this.stateDrawable, (int)layoutDirection);
            DrawableCompat.setLayoutDirection((Drawable)this.progressDrawable, (int)layoutDirection);
        }
    }

    private void retrieveImageDrawable(TypedArray array, int index) {
        if (array.hasValue(index)) {
            int resId = array.getResourceId(index, 0);
            if (resId != 0) {
                this.setDrawable(resId);
            }
        } else {
            this.failImageNotProvided();
        }
    }

    private StateListDrawable buildStateDrawable(Drawable drawable) {
        StateListDrawable result = new StateListDrawable();
        result.addState(STATE_SHOW_FRONT, drawable);
        Drawable background = drawable.getConstantState().newDrawable().mutate();
        DrawableCompat.setTint((Drawable)background, (int)this.backgroundColor);
        result.addState(STATE_SHOW_BACK, background);
        return result;
    }

    private ClipDrawable buildProgressDrawable(Drawable drawable) {
        return new ClipDrawable(drawable.getConstantState().newDrawable().mutate(), 0x800003, 1);
    }

    private void ensureNewDrawable(Drawable drawable) {
        if (drawable == null) {
            this.failImageNotProvided();
        }
    }

    private void cleanDrawables() {
        this.cleanDrawable((Drawable)this.stateDrawable);
    }

    private void cleanDrawable(Drawable drawable) {
        if (drawable != null) {
            drawable.setCallback(null);
            this.view.unscheduleDrawable(drawable);
        }
    }

    private void failImageNotProvided() {
        throw new RuntimeException(this.view.getContext().getString(R.string.error_needAnimatedVector));
    }

    public boolean isPreventInvalidation() {
        return this.preventInvalidation;
    }

    public void setBounds(Rect bounds) {
        this.stateDrawable.setBounds(bounds);
        this.progressDrawable.setBounds(bounds);
    }

    public Rect getBounds() {
        if (this.stateDrawable != null) {
            return new Rect(this.stateDrawable.getBounds());
        }
        return null;
    }

    public int getIntrinsicHeight() {
        return this.stateDrawable != null ? this.stateDrawable.getIntrinsicHeight() : 0;
    }

    public int getIntrinsicWidth() {
        return this.stateDrawable != null ? this.stateDrawable.getIntrinsicWidth() : 0;
    }

    public int getMinHeight() {
        return this.stateDrawable != null ? this.stateDrawable.getMinimumHeight() : 0;
    }

    public int getMinWidth() {
        return this.stateDrawable != null ? this.stateDrawable.getMinimumWidth() : 0;
    }

    public int getWidth() {
        return this.stateDrawable != null ? this.stateDrawable.getBounds().width() : 0;
    }

    ClipDrawable getProgressDrawable() {
        return this.progressDrawable;
    }

    public void drawProgress(Canvas canvas) {
        if (this.progressDrawable != null) {
            this.progressDrawable.draw(canvas);
        }
    }
}

