/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress.internal.drawing;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import com.teachonmars.modules.widget.segmentedProgress.SegmentedProgress;
import com.teachonmars.modules.widget.segmentedProgress.internal.drawing.DrawableManager;
import com.teachonmars.modules.widget.segmentedProgress.internal.drawing.SectionsCounter;
import java.util.ArrayList;

public class AnimationManager {
    private AnimatorSet levelAnimator;
    private DrawableManager drawableManager;
    private SectionsCounter sectionsCounter;
    private int currenSectionPos = 0;

    public AnimationManager(DrawableManager drawableManager, SectionsCounter sectionsCounter) {
        this.drawableManager = drawableManager;
        this.sectionsCounter = sectionsCounter;
    }

    public boolean isAnimating() {
        return this.levelAnimator != null && this.levelAnimator.isRunning();
    }

    public void interrupt(boolean goToEnd) {
        if (this.levelAnimator != null) {
            if (goToEnd) {
                this.levelAnimator.end();
            } else {
                this.levelAnimator.cancel();
            }
        }
    }

    public void animProgress(float progressPercent, SegmentedProgress view) {
        int end;
        ClipDrawable drawable = this.drawableManager.getProgressDrawable();
        int start = this.sectionsCounter.getShowCount();
        if (start != (end = this.sectionsCounter.calculateFuturCount(progressPercent))) {
            ArrayList<ObjectAnimator> items = new ArrayList<ObjectAnimator>();
            drawable.setState(DrawableManager.STATE_SHOW_FRONT);
            if (start < end) {
                for (int i = start + 1; i <= end; ++i) {
                    items.add(this.buildAnim((Drawable)drawable, 0, 10000, view, i));
                }
            } else {
                for (int i = start; i > end; --i) {
                    items.add(this.buildAnim((Drawable)drawable, 10000, 0, view, i));
                }
            }
            this.levelAnimator = new AnimatorSet();
            this.levelAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    AnimationManager.this.currenSectionPos = 0;
                }
            });
            this.levelAnimator.playSequentially(items);
            this.levelAnimator.start();
        }
    }

    private ObjectAnimator buildAnim(Drawable drawable, final int min, final int max, final SegmentedProgress view, final int pos) {
        ObjectAnimator result = ObjectAnimator.ofInt((Object)drawable, (String)"level", (int[])new int[]{min, max});
        result.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                AnimationManager.this.currenSectionPos = pos;
                if (max == 0) {
                    AnimationManager.this.sectionsCounter.setShowCount(AnimationManager.this.currenSectionPos - 1);
                    view.invalidate();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (min == 0) {
                    AnimationManager.this.sectionsCounter.setShowCount(AnimationManager.this.currenSectionPos);
                    view.invalidate();
                }
            }
        });
        result.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                view.invalidate();
            }
        });
        return result;
    }

    public int getAnimCurrentSectionPos() {
        return this.currenSectionPos;
    }
}

