/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress.internal;

import android.graphics.Rect;
import android.view.View;
import com.teachonmars.modules.widget.segmentedProgress.SegmentedProgress;
import com.teachonmars.modules.widget.segmentedProgress.internal.DrawingController;

public class ViewMeasurer {
    private final SegmentedProgress view;
    private final DrawingController drawingController;
    private Rect currentBound = new Rect();

    public ViewMeasurer(SegmentedProgress view, DrawingController drawingController) {
        this.view = view;
        this.drawingController = drawingController;
    }

    public Rect measure(int widthMeasureSpec, int heightMeasureSpec) {
        this.currentBound.set(0, 0, this.measuredWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
        this.drawingController.setBound(this.currentBound);
        return this.currentBound;
    }

    private int measureHeight(int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (heightMode) {
            case 0: {
                return this.measureHeightContent();
            }
            case -2147483648: {
                return Math.min(this.getParentRequestedSize(heightMeasureSpec), this.measureHeightContent());
            }
        }
        return this.getParentRequestedSize(heightMeasureSpec);
    }

    private int measuredWidth(int widthMeasureSpec) {
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        switch (specMode) {
            case 0: {
                return this.measuredWidthContent();
            }
        }
        return this.getParentRequestedSize(widthMeasureSpec);
    }

    private int getParentRequestedSize(int sizeMeasureSpec) {
        return View.MeasureSpec.getSize((int)sizeMeasureSpec);
    }

    private int measuredWidthContent() {
        return Math.max(this.drawingController.getWidth(), this.view.getSuggestedMinimumWidth());
    }

    private int measureHeightContent() {
        return Math.max(this.drawingController.getHeight(), this.view.getSuggestedMinimumHeight());
    }
}

