/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress.internal;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.view.View;
import com.teachonmars.modules.widget.segmentedProgress.SegmentedProgress;
import com.teachonmars.modules.widget.segmentedProgress.internal.drawing.AnimationManager;
import com.teachonmars.modules.widget.segmentedProgress.internal.drawing.DrawableManager;
import com.teachonmars.modules.widget.segmentedProgress.internal.drawing.SectionsCounter;

public class DrawingController {
    private final DrawableManager drawableManager;
    private SectionsCounter sectionsCounter;
    private AnimationManager animationManager;
    private SegmentedProgress view;

    public DrawingController(SegmentedProgress view) {
        this.view = view;
        this.sectionsCounter = new SectionsCounter();
        this.drawableManager = new DrawableManager(view);
        this.animationManager = new AnimationManager(this.drawableManager, this.sectionsCounter);
    }

    public void loadFromResources(TypedArray a, boolean inEditMode) {
        this.sectionsCounter.loadFromResources(a, inEditMode);
        this.drawableManager.loadFromResources(a, inEditMode);
    }

    public void setImageDrawable(Drawable drawable) {
        this.drawableManager.setImageDrawable(drawable);
    }

    public void setDrawable(int resId) {
        this.drawableManager.setDrawable(resId);
    }

    public boolean isPreventInvalidation() {
        return this.drawableManager.isPreventInvalidation();
    }

    public int getMinHeight() {
        return this.drawableManager.getMinHeight();
    }

    public int getMinWidth() {
        return this.drawableManager.getMinWidth() * this.sectionsCounter.getCount();
    }

    int getWidth() {
        return this.drawableManager.getIntrinsicWidth() * this.sectionsCounter.getCount();
    }

    int getHeight() {
        return this.drawableManager.getIntrinsicHeight();
    }

    public void draw(Canvas canvas) {
        int nbVisibleSection = this.sectionsCounter.getShowCount();
        int imageWidth = this.drawableManager.getWidth();
        this.drawBackground(canvas, nbVisibleSection, imageWidth);
        this.drawVisible(canvas, nbVisibleSection, imageWidth);
        this.drawProgress(canvas, imageWidth);
    }

    private void drawBackground(Canvas canvas, int nbVisibleSection, int imageWidth) {
        int total = this.sectionsCounter.getCount();
        if (nbVisibleSection != total) {
            this.drawableManager.setState(DrawableManager.STATE_SHOW_BACK);
            canvas.save();
            this.translateCanvasPadded(canvas, nbVisibleSection * imageWidth, 0);
            for (int i = nbVisibleSection; i < total; ++i) {
                this.drawableManager.draw(canvas);
                this.translateCanvas(canvas, imageWidth, 0);
            }
            canvas.restore();
        }
    }

    private void drawVisible(Canvas canvas, int nbVisibleSection, int imageWidth) {
        if (nbVisibleSection > 0) {
            this.drawableManager.setState(DrawableManager.STATE_SHOW_FRONT);
            canvas.save();
            this.translateCanvasPadded(canvas, 0, 0);
            for (int i = 0; i < nbVisibleSection; ++i) {
                this.drawableManager.draw(canvas);
                this.translateCanvas(canvas, imageWidth, 0);
            }
            canvas.restore();
        }
    }

    private void drawProgress(Canvas canvas, int imageWidth) {
        int currentAnimatedPos;
        if (this.animationManager.isAnimating() && (currentAnimatedPos = this.animationManager.getAnimCurrentSectionPos()) > 0) {
            canvas.save();
            this.translateCanvasPadded(canvas, (currentAnimatedPos - 1) * imageWidth, 0);
            this.drawableManager.drawProgress(canvas);
            canvas.restore();
        }
    }

    private void translateCanvasPadded(Canvas canvas, int left, int top) {
        this.translateCanvas(canvas, ViewCompat.getPaddingStart((View)this.view) + left, this.view.getPaddingTop() + top);
    }

    private void translateCanvas(Canvas canvas, int left, int top) {
        canvas.translate((float)left, (float)top);
    }

    void setBound(Rect viewBound) {
        int availableWidth = viewBound.width() - ViewCompat.getPaddingStart((View)this.view) - ViewCompat.getPaddingEnd((View)this.view);
        int availableHeight = viewBound.height() - this.view.getPaddingTop() - ViewCompat.getPaddingEnd((View)this.view);
        this.drawableManager.setBounds(new Rect(0, 0, availableWidth / this.sectionsCounter.getCount(), availableHeight));
    }

    public void setProgress(float progressPercent, boolean doAnim) {
        this.animationManager.interrupt(true);
        if (doAnim) {
            this.animationManager.animProgress(progressPercent, this.view);
        } else {
            this.updateProgress(progressPercent);
        }
    }

    private void updateProgress(float progressPercent) {
        Rect bounds;
        int oldCount = this.sectionsCounter.getShowCount();
        int newCount = this.sectionsCounter.setProgress(progressPercent);
        if (newCount < oldCount) {
            int tmp = oldCount;
            oldCount = newCount;
            newCount = tmp;
        }
        if ((bounds = this.drawableManager.getBounds()) != null && bounds.width() != 0) {
            bounds.set(oldCount * bounds.width(), this.view.getPaddingTop(), newCount * bounds.width(), this.view.getPaddingBottom() + bounds.height());
            this.view.invalidate(bounds);
        }
    }

    public float getProgress() {
        return this.sectionsCounter.getShowCount() / this.sectionsCounter.getCount();
    }

    public int getShowCount() {
        return this.sectionsCounter.getShowCount();
    }

    public void setNbSection(int nbSection) {
        this.sectionsCounter.setNbSection(nbSection);
        this.view.requestLayout();
    }
}

